/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.ErrorHandler;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.ParseIssue;
import io.mola.galimatias.URLParser;
import io.mola.galimatias.URLParsingSettings;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParseIssueTest {
    private ParseIssue parseIssue;
    private boolean errorIsFatal;
    private URLParser parser;
    private GalimatiasParseException errorException;
    private GalimatiasParseException fatalErrorException;

    @Parameterized.Parameters(name="{0}: {1}, fatal: {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"www.example.com", ParseIssue.MISSING_SCHEME, true}, {"http://www.example.com/%", ParseIssue.INVALID_PERCENT_ENCODING, false}, {"http://www.example.com\\path", ParseIssue.BACKSLASH_AS_DELIMITER, false}, {"http://us`er:pass@www.example.com/path", ParseIssue.ILLEGAL_CHARACTER, false}, {"http://www.exam\tple.com/path", ParseIssue.ILLEGAL_WHITESPACE, false}, {"http://user:pass@/path", ParseIssue.INVALID_HOST, true});
    }

    public ParseIssueTest(String url, ParseIssue parseIssue, boolean errorIsFatal) {
        this.parseIssue = parseIssue;
        this.errorIsFatal = errorIsFatal;
        this.parser = new URLParser(url);
        this.parser.settings(URLParsingSettings.create().withErrorHandler(new ErrorHandler(){

            @Override
            public void error(GalimatiasParseException error) throws GalimatiasParseException {
                ParseIssueTest.this.errorException = error;
                throw error;
            }

            @Override
            public void fatalError(GalimatiasParseException error) {
                ParseIssueTest.this.fatalErrorException = error;
            }
        }));
    }

    @Test
    public void handlesGalimiatiasParseExceptionWithCorrectParseIssue() throws GalimatiasParseException {
        try {
            this.parser.parse();
        }
        catch (GalimatiasParseException galimatiasParseException) {
            // empty catch block
        }
        if (this.errorIsFatal) {
            Assert.assertNotNull((String)"Fatal error expected", (Object)this.fatalErrorException);
            Assert.assertEquals((Object)((Object)this.parseIssue), (Object)((Object)this.fatalErrorException.getParseIssue()));
        } else {
            Assert.assertNotNull((String)"Non-fatal error expected", (Object)this.errorException);
            Assert.assertEquals((Object)((Object)this.parseIssue), (Object)((Object)this.errorException.getParseIssue()));
        }
    }
}

