/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class UntilNode
extends Node {
    private final Node conditionNode;
    private final Node bodyNode;
    private final boolean evaluateAtStart;

    public UntilNode(int line, Node conditionNode, Node bodyNode) {
        this(line, conditionNode, bodyNode, true);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNTILNODE;
    }

    public UntilNode(int line, Node conditionNode, Node bodyNode, boolean evaluateAtStart) {
        super(line, conditionNode.containsVariableAssignment() || bodyNode.containsVariableAssignment());
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evaluateAtStart;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitUntilNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }
}

