/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.node.IoUsageStats;

public class NodeResourceUsageStats
implements Writeable {
    final String nodeId;
    long timestamp;
    double cpuUtilizationPercent;
    double memoryUtilizationPercent;
    private IoUsageStats ioUsageStats;

    public NodeResourceUsageStats(String nodeId, long timestamp, double memoryUtilizationPercent, double cpuUtilizationPercent, IoUsageStats ioUsageStats) {
        this.nodeId = nodeId;
        this.timestamp = timestamp;
        this.cpuUtilizationPercent = cpuUtilizationPercent;
        this.memoryUtilizationPercent = memoryUtilizationPercent;
        this.ioUsageStats = ioUsageStats;
    }

    public NodeResourceUsageStats(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.timestamp = in.readLong();
        this.cpuUtilizationPercent = in.readDouble();
        this.memoryUtilizationPercent = in.readDouble();
        this.ioUsageStats = in.getVersion().onOrAfter(Version.V_2_13_0) ? (IoUsageStats)in.readOptionalWriteable(IoUsageStats::new) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeLong(this.timestamp);
        out.writeDouble(this.cpuUtilizationPercent);
        out.writeDouble(this.memoryUtilizationPercent);
        if (out.getVersion().onOrAfter(Version.V_2_13_0)) {
            out.writeOptionalWriteable((Writeable)this.ioUsageStats);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodeResourceUsageStats[");
        sb.append(this.nodeId).append("](");
        sb.append("Timestamp: ").append(this.timestamp);
        sb.append(", CPU utilization percent: ").append(String.format(Locale.ROOT, "%.1f", this.getCpuUtilizationPercent()));
        sb.append(", Memory utilization percent: ").append(String.format(Locale.ROOT, "%.1f", this.getMemoryUtilizationPercent()));
        if (this.ioUsageStats != null) {
            sb.append(", ").append(this.getIoUsageStats());
        }
        sb.append(")");
        return sb.toString();
    }

    NodeResourceUsageStats(NodeResourceUsageStats nodeResourceUsageStats) {
        this(nodeResourceUsageStats.nodeId, nodeResourceUsageStats.timestamp, nodeResourceUsageStats.memoryUtilizationPercent, nodeResourceUsageStats.cpuUtilizationPercent, nodeResourceUsageStats.ioUsageStats);
    }

    public double getMemoryUtilizationPercent() {
        return this.memoryUtilizationPercent;
    }

    public double getCpuUtilizationPercent() {
        return this.cpuUtilizationPercent;
    }

    public IoUsageStats getIoUsageStats() {
        return this.ioUsageStats;
    }

    public void setIoUsageStats(IoUsageStats ioUsageStats) {
        this.ioUsageStats = ioUsageStats;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

