/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.modes.CBCBlockCipher;
import org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.CFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.internal.modes.OFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.SICBlockCipher;
import org.bouncycastle.crypto.internal.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.internal.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.internal.paddings.PKCS7Padding;
import org.bouncycastle.crypto.internal.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.internal.paddings.TBCPadding;
import org.bouncycastle.crypto.internal.paddings.X923Padding;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

class BlockCipherUtils {
    private static SecureRandom defaultRandomPadder;

    BlockCipherUtils() {
    }

    static BufferedBlockCipher createBlockCipher(EngineProvider<BlockCipher> engineProvider, FipsParameters fipsParameters) {
        BlockCipher blockCipher = engineProvider.createEngine();
        Padding padding = (Padding)fipsParameters.getAlgorithm().additionalVariation();
        switch ((Mode)fipsParameters.getAlgorithm().basicVariation()) {
            case ECB: {
                break;
            }
            case CBC: {
                if (padding == Padding.CS1 || padding == Padding.CS2 || padding == Padding.CS3) break;
                blockCipher = new CBCBlockCipher(blockCipher);
                break;
            }
            case CFB8: {
                blockCipher = new CFBBlockCipher(blockCipher, 8);
                break;
            }
            case CFB64: {
                blockCipher = new CFBBlockCipher(blockCipher, 64);
                break;
            }
            case CFB128: {
                blockCipher = new CFBBlockCipher(blockCipher, 128);
                break;
            }
            case OFB64: {
                blockCipher = new OFBBlockCipher(blockCipher, 64);
                break;
            }
            case OFB128: {
                blockCipher = new OFBBlockCipher(blockCipher, 128);
                break;
            }
            case CTR: {
                blockCipher = new SICBlockCipher(blockCipher);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode passed to createBlockCipher: " + fipsParameters.getAlgorithm());
            }
        }
        if (padding != null) {
            switch (padding) {
                case PKCS7: {
                    return new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
                }
                case ISO7816_4: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO7816d4Padding());
                }
                case ISO10126_2: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO10126d2Padding());
                }
                case TBC: {
                    return new PaddedBufferedBlockCipher(blockCipher, new TBCPadding());
                }
                case X923: {
                    return new PaddedBufferedBlockCipher(blockCipher, new X923Padding());
                }
                case CS1: {
                    return new NISTCTSBlockCipher(1, blockCipher);
                }
                case CS2: {
                    return new NISTCTSBlockCipher(2, blockCipher);
                }
                case CS3: {
                    return new NISTCTSBlockCipher(3, blockCipher);
                }
            }
            throw new IllegalArgumentException("Unknown padding passed to createBlockCipher: " + fipsParameters.getAlgorithm());
        }
        return new DefaultBufferedBlockCipher(blockCipher);
    }

    static BufferedBlockCipher createStandardCipher(boolean bl, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, Parameters parameters, SecureRandom secureRandom) {
        Object object;
        BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createBlockCipher(engineProvider, (FipsParameters)parameters);
        CipherParameters cipherParameters = Utils.getKeyParameter(validatedSymmetricKey);
        if (parameters instanceof ParametersWithIV && (object = ((ParametersWithIV)parameters).getIV()) != null) {
            cipherParameters = new org.bouncycastle.crypto.internal.params.ParametersWithIV(cipherParameters, (byte[])object);
        }
        if (((FipsAlgorithm)parameters.getAlgorithm()).additionalVariation() instanceof Padding && ((Padding)((Object)(object = (Object)((Object)((Padding)((FipsAlgorithm)parameters.getAlgorithm()).additionalVariation()))))).getBasePadding().requiresRandom() && bl) {
            if (secureRandom != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
            } else {
                try {
                    cipherParameters = new ParametersWithRandom(cipherParameters, CryptoServicesRegistrar.getSecureRandom());
                }
                catch (IllegalStateException illegalStateException) {
                    cipherParameters = new ParametersWithRandom(cipherParameters, BlockCipherUtils.getDefaultRandomPadder());
                }
            }
        }
        bufferedBlockCipher.init(bl, cipherParameters);
        return bufferedBlockCipher;
    }

    static AEADBlockCipher createAEADCipher(FipsAlgorithm fipsAlgorithm, EngineProvider<BlockCipher> engineProvider) {
        AEADBlockCipher aEADBlockCipher;
        switch ((Mode)fipsAlgorithm.basicVariation()) {
            case CCM: {
                aEADBlockCipher = new CCMBlockCipher(engineProvider.createEngine());
                break;
            }
            case GCM: {
                aEADBlockCipher = new GCMBlockCipher(engineProvider.createEngine());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createAEADCipher: " + fipsAlgorithm);
            }
        }
        return aEADBlockCipher;
    }

    static synchronized SecureRandom getDefaultRandomPadder() {
        if (defaultRandomPadder == null) {
            defaultRandomPadder = FipsDRBG.SHA512.fromDefaultEntropy().setPersonalizationString(Strings.toByteArray("Bouncy Castle FIPS Default Padder")).build(Pack.longToBigEndian(System.currentTimeMillis()), false);
        }
        return defaultRandomPadder;
    }
}

