/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.charts;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.graalvm.visualvm.lib.ui.charts.BarChartModel;
import org.graalvm.visualvm.lib.ui.charts.ChartModelListener;

public abstract class AbstractBarChartModel
implements BarChartModel {
    private Collection<ChartModelListener> listeners = new CopyOnWriteArraySet<ChartModelListener>();

    @Override
    public abstract String getXAxisDesc();

    @Override
    public abstract String[] getXLabels();

    @Override
    public abstract String getYAxisDesc();

    @Override
    public abstract int[] getYValues();

    @Override
    public synchronized void addChartModelListener(ChartModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeChartModelListener(ChartModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChartDataChanged() {
        for (ChartModelListener l : this.listeners) {
            l.chartDataChanged();
        }
    }
}

