/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.parser.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.openjdk.jmc.flightrecorder.parser.filter.IOnLoadFilter;

public class OnLoadFilters {
    public static final IOnLoadFilter ALLOW_ALL_FILTER = new IOnLoadFilter(){

        @Override
        public boolean allowEventType(String eventId) {
            return true;
        }
    };

    public static IOnLoadFilter includeEvents(Collection<String> includedTypeIds) {
        final HashSet<String> includedSet = new HashSet<String>(includedTypeIds);
        return new IOnLoadFilter(){

            @Override
            public boolean allowEventType(String typeId) {
                return includedSet.contains(typeId);
            }
        };
    }

    public static IOnLoadFilter excludeEvents(Collection<String> excludedTypeIds) {
        final HashSet<String> excludedSet = new HashSet<String>(excludedTypeIds);
        return new IOnLoadFilter(){

            @Override
            public boolean allowEventType(String typeId) {
                return !excludedSet.contains(typeId);
            }
        };
    }

    public static IOnLoadFilter includeEvents(final Pattern includeRegexp) {
        return new IOnLoadFilter(){

            @Override
            public boolean allowEventType(String typeId) {
                return includeRegexp.matcher(typeId).matches();
            }
        };
    }

    public static IOnLoadFilter excludeEvents(final Pattern excludeRegexp) {
        return new IOnLoadFilter(){

            @Override
            public boolean allowEventType(String typeId) {
                return !excludeRegexp.matcher(typeId).matches();
            }
        };
    }
}

