import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { UpdateDistributionWithStagingConfigResultFilterSensitiveLog, } from "../models/models_2";
import { de_UpdateDistributionWithStagingConfigCommand, se_UpdateDistributionWithStagingConfigCommand, } from "../protocols/Aws_restXml";
export { $Command };
export class UpdateDistributionWithStagingConfigCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "UpdateDistributionWithStagingConfig", {})
    .n("CloudFrontClient", "UpdateDistributionWithStagingConfigCommand")
    .f(void 0, UpdateDistributionWithStagingConfigResultFilterSensitiveLog)
    .ser(se_UpdateDistributionWithStagingConfigCommand)
    .de(de_UpdateDistributionWithStagingConfigCommand)
    .build() {
}
