/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.building;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Source;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingResult;
import org.apache.maven.settings.building.DefaultSettingsProblemCollector;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsProblemCollector;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.merge.MavenSettingsMerger;
import org.apache.maven.settings.validation.SettingsValidator;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;

@Named
@Singleton
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private SettingsReader settingsReader;
    private SettingsWriter settingsWriter;
    private SettingsValidator settingsValidator;
    private final MavenSettingsMerger settingsMerger = new MavenSettingsMerger();

    @Inject
    public DefaultSettingsBuilder(SettingsReader settingsReader, SettingsWriter settingsWriter, SettingsValidator settingsValidator) {
        this.settingsReader = settingsReader;
        this.settingsWriter = settingsWriter;
        this.settingsValidator = settingsValidator;
    }

    public DefaultSettingsBuilder setSettingsReader(SettingsReader settingsReader) {
        this.settingsReader = settingsReader;
        return this;
    }

    public DefaultSettingsBuilder setSettingsWriter(SettingsWriter settingsWriter) {
        this.settingsWriter = settingsWriter;
        return this;
    }

    public DefaultSettingsBuilder setSettingsValidator(SettingsValidator settingsValidator) {
        this.settingsValidator = settingsValidator;
        return this;
    }

    @Override
    public SettingsBuildingResult build(SettingsBuildingRequest request) throws SettingsBuildingException {
        File file2;
        DefaultSettingsProblemCollector problems = new DefaultSettingsProblemCollector(null);
        Source globalSettingsSource = this.getSettingsSource(request.getGlobalSettingsFile(), request.getGlobalSettingsSource());
        Settings globalSettings = this.readSettings(globalSettingsSource, request, problems);
        Source userSettingsSource = this.getSettingsSource(request.getUserSettingsFile(), request.getUserSettingsSource());
        Settings userSettings = this.readSettings(userSettingsSource, request, problems);
        this.settingsMerger.merge(userSettings, globalSettings, "global-level");
        problems.setSource("");
        userSettings = this.interpolate(userSettings, request, problems);
        String localRepository = userSettings.getLocalRepository();
        if (localRepository != null && localRepository.length() > 0 && !(file2 = new File(localRepository)).isAbsolute() && file2.getPath().startsWith(File.separator)) {
            userSettings.setLocalRepository(file2.getAbsolutePath());
        }
        if (this.hasErrors(problems.getProblems())) {
            throw new SettingsBuildingException(problems.getProblems());
        }
        return new DefaultSettingsBuildingResult(userSettings, problems.getProblems());
    }

    private boolean hasErrors(List<SettingsProblem> problems) {
        if (problems != null) {
            for (SettingsProblem problem : problems) {
                if (SettingsProblem.Severity.ERROR.compareTo(problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private Source getSettingsSource(File settingsFile, Source settingsSource) {
        if (settingsSource != null) {
            return settingsSource;
        }
        if (settingsFile != null && settingsFile.exists()) {
            return new FileSource(settingsFile);
        }
        return null;
    }

    private Settings readSettings(Source settingsSource, SettingsBuildingRequest request, DefaultSettingsProblemCollector problems) {
        Settings settings;
        if (settingsSource == null) {
            return new Settings();
        }
        problems.setSource(settingsSource.getLocation());
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.settings.io.isStrict", Boolean.TRUE);
            try {
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
            }
            catch (SettingsParseException e2) {
                options = Collections.singletonMap("org.apache.maven.settings.io.isStrict", Boolean.FALSE);
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
                problems.add(SettingsProblem.Severity.WARNING, e2.getMessage(), e2.getLineNumber(), e2.getColumnNumber(), e2);
            }
        }
        catch (SettingsParseException e3) {
            problems.add(SettingsProblem.Severity.FATAL, "Non-parseable settings " + settingsSource.getLocation() + ": " + e3.getMessage(), e3.getLineNumber(), e3.getColumnNumber(), e3);
            return new Settings();
        }
        catch (IOException e4) {
            problems.add(SettingsProblem.Severity.FATAL, "Non-readable settings " + settingsSource.getLocation() + ": " + e4.getMessage(), -1, -1, e4);
            return new Settings();
        }
        this.settingsValidator.validate(settings, problems);
        return settings;
    }

    private Settings interpolate(Settings settings, SettingsBuildingRequest request, SettingsProblemCollector problems) {
        Settings result;
        StringWriter writer2 = new StringWriter(4096);
        try {
            this.settingsWriter.write(writer2, null, settings);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Failed to serialize settings to memory", e2);
        }
        String serializedSettings = writer2.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource(new PropertiesBasedValueSource(request.getUserProperties()));
        interpolator.addValueSource(new PropertiesBasedValueSource(request.getSystemProperties()));
        try {
            interpolator.addValueSource(new EnvarBasedValueSource());
        }
        catch (IOException e3) {
            problems.add(SettingsProblem.Severity.WARNING, "Failed to use environment variables for interpolation: " + e3.getMessage(), -1, -1, e3);
        }
        interpolator.addPostProcessor(new InterpolationPostProcessor(){

            @Override
            public Object execute(String expression, Object value) {
                if (value != null) {
                    value = value.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                    return value;
                }
                return null;
            }
        });
        try {
            serializedSettings = interpolator.interpolate(serializedSettings, "settings");
        }
        catch (InterpolationException e4) {
            problems.add(SettingsProblem.Severity.ERROR, "Failed to interpolate settings: " + e4.getMessage(), -1, -1, e4);
            return settings;
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.settings.io.isStrict", Boolean.FALSE);
            result = this.settingsReader.read(new StringReader(serializedSettings), options);
        }
        catch (IOException e5) {
            problems.add(SettingsProblem.Severity.ERROR, "Failed to interpolate settings: " + e5.getMessage(), -1, -1, e5);
            return settings;
        }
        return result;
    }
}

