/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import javajs.util.Base64;
import javajs.util.PT;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;
import org.jmol.util.Elements;

public class NMRMLReader
extends XMLReader {
    private String structure;
    private String assignment;
    private int dim = 1;

    @Override
    protected JDXSource getXML(BufferedReader br) {
        try {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(br);
            this.parser.nextEvent();
            this.processXML(13, 33);
            if (!this.checkPointCount()) {
                return null;
            }
            this.xFactor = 1.0;
            this.yFactor = 1.0;
            this.populateVariables();
        }
        catch (Exception pe) {
            System.err.println("That file may be empty...");
            this.errorLog.append("That file may be empty... \n");
        }
        this.processErrors("nmrML");
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    @Override
    protected boolean processTag(int tagId) throws Exception {
        System.out.println(tagNames[tagId]);
        switch (tagId) {
            case 13: {
                this.obNucleus = Elements.getNmrNucleusFromName(this.parser.getAttrValueLC("name"));
                return true;
            }
            case 14: {
                this.strObFreq = this.parser.getAttrValueLC("value");
                this.obFreq = Double.parseDouble(this.strObFreq);
                return true;
            }
            case 15: {
                this.dim = 1;
                break;
            }
            case 32: {
                String type = this.parser.getAttrValue("byteFormat");
                if (!"complex128".equals(type)) break;
                this.getXYFromBase64Complex128(this.parser.getCharacters());
                break;
            }
            case 18: {
                this.title = this.parser.getAttrValue("name");
                break;
            }
            case 20: {
                this.structure = NMRMLReader.toCML(this.parser.getInnerXML());
                break;
            }
            case 25: {
                this.assignment = this.parser.getOuterXML();
                break;
            }
        }
        return false;
    }

    private static String toCML(String structure) {
        structure = PT.rep(structure, "x=", "x3=");
        structure = PT.rep(structure, "y=", "y3=");
        structure = PT.rep(structure, "z=", "z3=");
        structure = PT.rep(structure, "atomList", "atomArray");
        structure = PT.rep(structure, "bondList", "bondArray");
        structure = PT.rep(structure, "atomRefs", "atomRefs2");
        structure = PT.rep(structure, ">\"", ">");
        structure = "<cml>\n<molecule>\n" + structure + "\n</molecule>\n</cml>";
        return structure;
    }

    @Override
    protected void processEndTag(int tagId) throws Exception {
    }

    private void getXYFromBase64Complex128(String sdata) {
        byte[] bytes = Base64.decodeBase64(sdata);
        DoubleBuffer b = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        if (bytes.length % 16 != 0) {
            throw new RuntimeException("NMRMLReader byte length not multiple of 16 " + bytes.length);
        }
        try {
            int n = bytes.length / 16;
            this.xaxisData = new double[n];
            this.yaxisData = new double[n];
            for (int i = 0; i < n; ++i) {
                this.xaxisData[n - i - 1] = b.get();
                this.yaxisData[n - i - 1] = b.get();
            }
            this.npoints = n;
            this.firstX = this.xaxisData[0];
            this.deltaX = this.xaxisData[1] - this.firstX;
            this.increasing = false;
            this.continuous = true;
            this.lastX = this.xaxisData[this.npoints - 1];
            this.yUnits = "";
            this.firstY = this.yaxisData[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

