/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.api.JmolScriptEvaluator;
import org.jmol.script.ScriptContext;
import org.jmol.thread.HoverWatcherThread;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class JmolThread
extends Thread {
    public String name = "JmolThread";
    private static int threadIndex;
    protected static final int INIT = -1;
    protected static final int MAIN = 0;
    protected static final int FINISH = -2;
    protected static final int CHECK1 = 1;
    protected static final int CHECK2 = 2;
    protected static final int CHECK3 = 3;
    protected Viewer vwr;
    protected JmolScriptEvaluator eval;
    protected ScriptContext sc;
    protected boolean haveReference;
    protected boolean hoverEnabled;
    protected long startTime;
    protected long targetTime;
    protected long lastRepaintTime;
    protected long currentTime;
    protected int sleepTime;
    protected boolean isJS;
    protected boolean stopped = false;
    protected boolean isReset;
    protected boolean useTimeout = true;
    double junk;

    public int setManager(Object manager, Viewer vwr, Object params) {
        return 0;
    }

    public void setViewer(Viewer vwr, String name) {
        this.setName(name);
        this.name = name + "_" + ++threadIndex;
        this.vwr = vwr;
        this.isJS = vwr.isSingleThreaded;
    }

    protected abstract void run1(int var1) throws InterruptedException;

    public void setEval(JmolScriptEvaluator eval) {
        this.eval = eval;
        this.sc = this.vwr.getEvalContextAndHoldQueue(eval);
        if (this.sc != null) {
            this.useTimeout = eval.getAllowJSThreads();
        }
    }

    public void resumeEval() {
        if (this.eval == null || !this.isJS && !this.vwr.testAsync || !this.useTimeout) {
            return;
        }
        this.sc.mustResumeEval = !this.stopped;
        JmolScriptEvaluator eval = this.eval;
        ScriptContext sc = this.sc;
        this.eval = null;
        this.sc = null;
        eval.resumeEval(sc);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        try {
            this.run1(-1);
        }
        catch (InterruptedException e) {
            if (Logger.debugging && !(this instanceof HoverWatcherThread)) {
                this.oops(e);
            }
        }
        catch (Exception e) {
            this.oops(e);
        }
    }

    protected void oops(Exception e) {
        Logger.debug(this.name + " exception " + e);
        if (!Viewer.isJS || Viewer.isSwingJS) {
            e.printStackTrace();
        }
        this.vwr.queueOnHold = false;
    }

    protected boolean runSleep(int millis, int runPtr) throws InterruptedException {
        if (this.isJS && !this.useTimeout) {
            return true;
        }
        if (millis > 0) {
            try {
                Thread.sleep(millis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void interrupt() {
        this.stopped = true;
        this.vwr.startHoverWatcher(true);
        if (!this.isJS) {
            super.interrupt();
        }
    }

    protected boolean checkInterrupted(JmolThread ref) {
        if (this.haveReference && (ref == null || !ref.name.equals(this.name))) {
            return true;
        }
        return super.isInterrupted();
    }

    public void reset() {
        this.isReset = true;
        this.interrupt();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

