/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.utils.CommonUtils;

public class AnnotationsInformationView {
    private static final Log log = Log.getLog(AnnotationsInformationView.class);
    @NotNull
    private final IHyperlinkListener hyperlinkListener = new IHyperlinkListener(){
        private Point oldSelection = null;

        public void linkEntered(@NotNull HyperlinkEvent e) {
            Object object = e.getHref();
            if (object instanceof AnnotationHyperlinkInfo) {
                AnnotationHyperlinkInfo hyperlink = (AnnotationHyperlinkInfo)object;
                this.oldSelection = AnnotationsInformationView.this.editor.getTextViewer() != null ? AnnotationsInformationView.this.editor.getTextViewer().getSelectedRange() : null;
                Position hyperlinkRegion = hyperlink.position();
                if (!hyperlinkRegion.isDeleted) {
                    AnnotationsInformationView.this.editor.getTextViewer().setSelectedRange(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength());
                }
            }
        }

        public void linkExited(@NotNull HyperlinkEvent e) {
            if (this.oldSelection != null && AnnotationsInformationView.this.editor.getTextViewer() != null) {
                AnnotationsInformationView.this.editor.getTextViewer().setSelectedRange(this.oldSelection.x, this.oldSelection.y);
                this.oldSelection = null;
            }
        }

        public void linkActivated(@NotNull HyperlinkEvent e) {
            Object object = e.getHref();
            if (object instanceof AnnotationHyperlinkInfo) {
                AnnotationHyperlinkInfo hyperlink = (AnnotationHyperlinkInfo)object;
                hyperlink.open(AnnotationsInformationView.this.editor);
            }
        }
    };
    private Composite linksContainer;
    private int tooltipAnchorLine = -1;
    private IRegion tooltipAnchorRegion = null;
    private boolean forceAnnotationIcon = false;
    private final AbstractInformationControl container;
    private final SQLEditorBase editor;

    public AnnotationsInformationView(@NotNull AbstractInformationControl container, @NotNull SQLEditorBase editor) {
        this.container = container;
        this.editor = editor;
    }

    public Control createControl(@NotNull Composite parent) {
        this.linksContainer = UIUtils.createComposite((Composite)parent, (int)1);
        return this.linksContainer;
    }

    public void setForceAnnotationIcon(boolean value) {
        this.forceAnnotationIcon = value;
    }

    public void setLinksInformation(@NotNull AnnotationsHoverInfo hoverInfo) {
        this.tooltipAnchorLine = hoverInfo.tooltipAnchorLine;
        this.tooltipAnchorRegion = hoverInfo.hoverRegion;
        if (hoverInfo.annotationsGroups().isEmpty()) {
            this.linksContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(0, 0).margins(0, 0).create());
        } else {
            this.linksContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            for (AnnotationsGroupInfo annotationGroup : hoverInfo.annotationsGroups()) {
                Composite linksGroupContainer;
                if (hoverInfo.annotationsGroups().size() > 1 || this.forceAnnotationIcon) {
                    linksGroupContainer = UIUtils.createComposite((Composite)this.linksContainer, (int)2);
                    DBIcon icon = annotationGroup.getIcon();
                    if (icon != null) {
                        UIUtils.createLabel((Composite)linksGroupContainer, (DBPImage)icon);
                    } else {
                        UIUtils.createPlaceholder((Composite)linksGroupContainer, (int)1);
                    }
                } else {
                    linksGroupContainer = this.linksContainer;
                }
                List<AnnotationHyperlinkInfo> hyperlinks = annotationGroup.getAnnotations();
                assert (!hyperlinks.isEmpty());
                int alsoLinksToShow = Math.min(5, hyperlinks.size() - 1) + 1;
                Composite groupLinksContainer = UIUtils.createPlaceholder((Composite)linksGroupContainer, (int)(hyperlinks.size() == 1 ? 1 : alsoLinksToShow * 2 + 1), (int)0);
                this.createHyperlinkControl(groupLinksContainer, hyperlinks.getFirst(), annotationGroup.getMessage());
                if (hyperlinks.size() <= 2) continue;
                UIUtils.createLabel((Composite)groupLinksContainer, (String)" (also at position ");
                int i = 1;
                while (i < alsoLinksToShow) {
                    AnnotationHyperlinkInfo hyperlink = hyperlinks.get(i);
                    if (i > 1) {
                        UIUtils.createLabel((Composite)groupLinksContainer, (String)", ");
                    }
                    this.createHyperlinkControl(groupLinksContainer, hyperlink, Integer.toString(hyperlink.position().getOffset()));
                    ++i;
                }
                UIUtils.createLabel((Composite)groupLinksContainer, (String)(hyperlinks.size() <= 5 ? ")" : ", ... " + hyperlinks.size() + " such problems in line)"));
            }
        }
        this.container.getShell().pack(true);
    }

    public void show() {
        if ((this.tooltipAnchorLine >= 0 || this.tooltipAnchorRegion != null) && this.editor.getDocument() != null && this.editor.getTextViewer() != null) {
            try {
                IRegion modelLineRange = this.tooltipAnchorRegion != null ? this.tooltipAnchorRegion : this.editor.getDocument().getLineInformation(this.tooltipAnchorLine);
                IRegion visualLineRange = this.editor.getTextViewer().modelRange2WidgetRange(modelLineRange);
                StyledText widget = this.editor.getTextViewer().getTextWidget();
                int offset = visualLineRange.getOffset();
                int length = visualLineRange.getLength();
                Rectangle localLineBounds = widget.getTextBounds(offset, offset + (length > 0 ? length - 1 : length));
                Rectangle globalLineBounds = Geometry.toDisplay((Control)widget, (Rectangle)localLineBounds);
                Rectangle globalWidgetBounds = Geometry.toDisplay((Control)widget, (Rectangle)widget.getBounds());
                int y = Math.min(globalLineBounds.y + globalLineBounds.height, globalWidgetBounds.y + globalWidgetBounds.height - widget.getHorizontalBar().getSize().y);
                Shell shell = this.container.getShell();
                boolean hasTooltipRanAway = !globalWidgetBounds.intersects(shell.getBounds());
                Rectangle adjustedBounds = new Rectangle(globalLineBounds.x, y, globalLineBounds.width, globalLineBounds.height);
                if (shell.getBounds().intersects(adjustedBounds) || hasTooltipRanAway || this.tooltipAnchorRegion != null) {
                    int x = hasTooltipRanAway || this.tooltipAnchorRegion != null ? Math.min(widget.getDisplay().getCursorLocation().x, globalLineBounds.x) : shell.getBounds().x;
                    shell.setLocation(new Point(x, y));
                }
                shell.pack(true);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void createHyperlinkControl(@NotNull Composite groupLinksContainer, @NotNull AnnotationHyperlinkInfo hyperlink, @NotNull String text) {
        SQLSemanticErrorAnnotation s;
        String underlyingError;
        Hyperlink link = new Hyperlink(groupLinksContainer, 0);
        link.setHref((Object)hyperlink);
        link.setText(text);
        link.setUnderlined(true);
        link.addHyperlinkListener(this.hyperlinkListener);
        Annotation annotation = hyperlink.annotation();
        if (annotation instanceof SQLSemanticErrorAnnotation && CommonUtils.isNotEmpty((String)(underlyingError = (s = (SQLSemanticErrorAnnotation)annotation).getUnderlyingErrorMessage()))) {
            link.setToolTipText(underlyingError);
        }
    }

    public record AnnotationHyperlinkInfo(@NotNull Annotation annotation, @NotNull Position position) {
        public void open(SQLEditorBase editor) {
            TextViewer textViewer = editor.getTextViewer();
            if (textViewer != null && !this.position.isDeleted) {
                textViewer.setSelectedRange(this.position.getOffset(), this.position.getLength());
                textViewer.revealRange(this.position.getOffset(), this.position.getLength());
                textViewer.getTextWidget().setFocus();
            }
        }
    }

    public static class AnnotationsGroupInfo {
        private static final Position MIN_POSITION = new Position(0, 0);
        private static final Position MAX_POSITION = new Position(Integer.MAX_VALUE, 0);
        private static final int UNKNOWN_SEVERITY = -1;
        @NotNull
        private final List<AnnotationHyperlinkInfo> annotations = new ArrayList<AnnotationHyperlinkInfo>();
        @NotNull
        private final String message;
        @NotNull
        private Position firstPosition = MAX_POSITION;
        @NotNull
        private Position lastPosition = MIN_POSITION;
        private int severity = -1;

        public AnnotationsGroupInfo(@NotNull String message) {
            this.message = message;
        }

        public void add(@NotNull Annotation anno, @NotNull Position annoPosition) {
            Position firstPos = this.firstPosition;
            if (firstPos.offset > annoPosition.offset) {
                this.firstPosition = annoPosition;
            }
            Position lastPos = this.lastPosition;
            if (lastPos.offset + lastPos.length < annoPosition.offset + annoPosition.length) {
                this.lastPosition = annoPosition;
            }
            AnnotationHyperlinkInfo entry = new AnnotationHyperlinkInfo(anno, annoPosition);
            STMUtils.orderedInsert(this.annotations, e -> e.position().getOffset(), (Object)entry, Integer::compare);
            this.severity = Math.max(this.severity, this.getAnnotationSeverity(anno));
        }

        @NotNull
        public List<AnnotationHyperlinkInfo> getAnnotations() {
            return this.annotations;
        }

        @NotNull
        public String getMessage() {
            return this.message;
        }

        @NotNull
        public Position getFirstPosition() {
            return this.firstPosition;
        }

        @NotNull
        public Position getLastPosition() {
            return this.lastPosition;
        }

        @Nullable
        public DBIcon getIcon() {
            return switch (this.severity) {
                case 2 -> DBIcon.SMALL_ERROR;
                case 1 -> DBIcon.SMALL_WARNING;
                case 0 -> DBIcon.SMALL_INFO;
                default -> null;
            };
        }

        private int getAnnotationSeverity(@NotNull Annotation anno) {
            if (anno instanceof MarkerAnnotation) {
                MarkerAnnotation ma = (MarkerAnnotation)anno;
                try {
                    int n;
                    Object object = ma.getMarker().getAttribute("severity");
                    if (object instanceof Integer) {
                        Integer n2 = (Integer)object;
                        n = n2;
                    } else {
                        n = 0;
                    }
                    return n;
                }
                catch (CoreException e) {
                    log.error((Object)"Failed to obtain annotation severity icon", (Throwable)e);
                    return -1;
                }
            }
            return 0;
        }
    }

    public record AnnotationsHoverInfo(@NotNull List<AnnotationsGroupInfo> annotationsGroups, @Nullable IRegion hoverRegion, int tooltipAnchorLine) {
    }
}

