#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-GpYiLeSX8dsGx5rqCF7zHf
key:                  dhall-1.42.3-GpYiLeSX8dsGx5rqCF7zHf
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  e4576718aeefdd35f2e2e6abf4247fa4
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-GpYiLeSX8dsGx5rqCF7zHf
depends:
    Diff-0.5-9qiiyCdSA6S4nsIW4gNy1l
    aeson-2.1.2.1-Kx5U0b11hXDAcrJPuBeHuf
    aeson-pretty-0.8.10-DpjvmV6phinAojOaBWzDlt
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-7KtFbOvBy9u8fJFoudPHf1 base-4.17.2.1
    base16-bytestring-1.0.2.0-KXYtISPPGuc1jDx46dDwiE
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4NRudSZIbdgEwzMbC5HpSf
    cborg-0.2.10.0-cY7ABn6zHqI135F66JDHz
    cborg-json-0.2.6.0-1Q7WGcq5NVpDkRfZiD0G0B containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-FLi6jxSY7ODlBeNiGHbS
    data-fix-0.3.4-IA7YOqN9XAw3iPOtrwRukb deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-6Yv9aYC5RunDrOwefPnrne exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-oMVSCc4lnO1XFEqMmYcf7
    hashable-1.4.6.0-2hEv5lQFD6LEJdTUNcXkaI haskeline-0.8.2
    http-client-0.7.19-6519OECLAFwEwnL7Zu0xmW
    http-client-tls-0.3.6.4-CB4kSvmWkV2Ki3PB3JtnDL
    http-types-0.12.4-AnyveerSvWp9fcmJ7pBmmy
    indexed-traversable-0.1.4-21HfwHBcrgA8B9HfAQ8T5X
    megaparsec-9.7.0-CvA3wDhViq5BjXD55Lo9fs
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-JKWvmQYUpUN61cz8IfYdaz
    optparse-applicative-0.18.1.0-1Ar9aW9o69J8KQyhUKGEja
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-B30LzqhGGjQ5kXscUvu5VS
    pretty-simple-4.1.3.0-9ROtWd9PLeXIZR1phwI2nV
    prettyprinter-1.7.1-KzM58U4JCdzBv7NnMyEr6Q
    prettyprinter-ansi-terminal-1.1.3-3BjvAoYDc5N1kq8bNZvQTL
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-EkghYeMOx113vCMjgUsNh4
    serialise-0.2.6.1-JTf0lHZawMi7YErOUNbSyE template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-Kxd1dl0N1gOBM5ccGknbxS
    text-short-0.1.6-CBCbguYMAXaBasFAvR4fHi
    th-lift-instances-0.1.20-GTDWx2wTGlUEikszfZC0RT time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-7wl3VN2bkjVLyACPiFBxN
    unordered-containers-0.2.20-Jnp6Xrk1NDm4qrPXFyeyaF
    vector-0.13.2.0-HGgKaKiJszd4ty04a0OkB8

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

