#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.4
visibility:           public
id:                   brick-2.4-H4sb6mfYeWL89U9zUo4uD7
key:                  brick-2.4-H4sb6mfYeWL89U9zUo4uD7
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2024
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  42fcfbf26fdde17a6d8e50582cfb231d
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Normalize Brick.Keybindings.Parse
    Brick.Keybindings.Pretty Brick.Main Brick.Themes Brick.Types
    Brick.Util Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-2.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-2.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.4-H4sb6mfYeWL89U9zUo4uD7
depends:
    base-4.17.2.1 bimap-0.5.0-DS5wplpnJZM6JVU2WqAPyn
    bytestring-0.11.5.3 config-ini-0.2.7.0-9emxpH3YnEjCJ0NHs1g8Q6
    containers-0.6.7 data-clist-0.2-E1xX9q9IOf8DvTf6jNxjow
    deepseq-1.4.8.0 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 mtl-2.2.2 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-AysX7IsPKfPEfIp1nGtEBK
    unix-compat-0.7.4.1-7wl3VN2bkjVLyACPiFBxN
    vector-0.13.2.0-HGgKaKiJszd4ty04a0OkB8
    vty-6.2-2Zk58nLaFuB9QmJmOEY2P2
    vty-crossplatform-0.4.0.0-1JXa59CB9q97E7Uno6LJmJ
    word-wrap-0.5-LMyUapeMguQCaoIuQr2UbP

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

