#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 serialise
version:              0.2.6.1
visibility:           public
id:                   serialise-0.2.6.1-JTf0lHZawMi7YErOUNbSyE
key:                  serialise-0.2.6.1-JTf0lHZawMi7YErOUNbSyE
license:              BSD-3-Clause
copyright:
    2015-2017 Duncan Coutts,
    2015-2017 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
homepage:             https://github.com/well-typed/cborg
synopsis:             A binary serialisation library for Haskell values.
description:
    This package (formerly @binary-serialise-cbor@) provides pure, efficient
    serialization of Haskell values directly into @ByteString@s for storage or
    transmission purposes. By providing a set of type class instances, you can
    also serialise any custom data type you have as well.

    The underlying binary format used is the '\''Concise Binary Object
    Representation'\'', or CBOR, specified in RFC 7049. As a result,
    serialised Haskell values have implicit structure outside of the
    Haskell program itself, meaning they can be inspected or analyzed
    without custom tools.

    An implementation of the standard bijection between CBOR and JSON is provided
    by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility for
    working with CBOR data.

category:             Codec
abi:                  3bf368caa8ba5c99c071c84871614105
exposed:              True
exposed-modules:
    Codec.Serialise Codec.Serialise.Class Codec.Serialise.Decoding
    Codec.Serialise.Encoding Codec.Serialise.IO
    Codec.Serialise.Internal.GeneralisedUTF8 Codec.Serialise.Properties
    Codec.Serialise.Tutorial

import-dirs:          /usr/lib/ghc-9.4.8/site-local/serialise-0.2.6.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/serialise-0.2.6.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/serialise-0.2.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-serialise
hs-libraries:         HSserialise-0.2.6.1-JTf0lHZawMi7YErOUNbSyE
depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
    cborg-0.2.10.0-cY7ABn6zHqI135F66JDHz containers-0.6.7
    ghc-prim-0.9.1 half-0.3.3-oMVSCc4lnO1XFEqMmYcf7
    hashable-1.4.6.0-2hEv5lQFD6LEJdTUNcXkaI
    primitive-0.9.1.0-HwFZTTOa0hJ3Qigb2ez2OX
    strict-0.5-Cxsc8ZUfZoPLkiT3nwMZis text-2.0.2
    these-1.2.1-DmtZsYfxIlcIuSDQtaoDDz time-1.12.2
    unordered-containers-0.2.20-Jnp6Xrk1NDm4qrPXFyeyaF
    vector-0.13.2.0-HGgKaKiJszd4ty04a0OkB8

haddock-interfaces:   /usr/share/doc/haskell-serialise/html/serialise.haddock
haddock-html:         /usr/share/doc/haskell-serialise/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

