#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-Io5QK5LwZV13cNpal1rjlN
key:                  trifecta-2.1.4-Io5QK5LwZV13cNpal1rjlN
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  df0352972ce3b99c73ee031a265e7c47
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-Io5QK5LwZV13cNpal1rjlN
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-1FzL5H3VdrlIMESDUNYF6f
    blaze-html-0.9.2.0-KhmoRG3R09V549Pilp7yk8
    blaze-markup-0.8.3.0-7r16xFnCpy97jSGDBGxZET bytestring-0.11.5.3
    charset-0.3.12-KHcjHL5YhCa6JzrYN0R7sF
    comonad-5.0.9-KQjrKTkwUDSJPrPBE30cK containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-E5pj85ZMZfsEuBSfHJRBVx
    ghc-prim-0.9.1 hashable-1.4.6.0-2hEv5lQFD6LEJdTUNcXkaI
    indexed-traversable-0.1.4-21HfwHBcrgA8B9HfAQ8T5X
    lens-5.3.2-LURSnBuXCqTHeh00mrfrRc mtl-2.2.2
    parsers-0.12.12-B30LzqhGGjQ5kXscUvu5VS
    prettyprinter-1.7.1-KzM58U4JCdzBv7NnMyEr6Q
    prettyprinter-ansi-terminal-1.1.3-3BjvAoYDc5N1kq8bNZvQTL
    profunctors-5.6.3-CCfJI8tgRIPBp3AVzibRmu
    reducers-3.12.5-JdMJ8OQNvUCFjE7dv0sjKT transformers-0.5.6.2
    unordered-containers-0.2.20-Jnp6Xrk1NDm4qrPXFyeyaF
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

