#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-Atrr7tbxEfqIcIZKNWyZ9P
key:                  trifecta-2.1.4-Atrr7tbxEfqIcIZKNWyZ9P
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f8832dcaffa88ba95dcbdfa1e9816b66
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-Atrr7tbxEfqIcIZKNWyZ9P
depends:
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-29vQnqICbd0LBEdca9xRON
    blaze-html-0.9.2.0-BNiEFLNNUNIEHlooTHUqgE
    blaze-markup-0.8.3.0-9A4diNUSs8a27GmMCxTlZs bytestring-0.11.5.3
    charset-0.3.12-7ot3GqIghNX1ogLUzn3gfw
    comonad-5.0.9-BUfUvZTVnr32onNIW7o2Zf containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-7AxUHqvXA3bDNud4CQ1lmM
    ghc-prim-0.9.1 hashable-1.4.6.0-JiQr1Tltq7G4W5bcwnoSMj
    indexed-traversable-0.1.4-4QkGZjX8pz4IX54GPYwjuC
    lens-5.3.2-5iQf9T9ZD7E1oav0YIbKON mtl-2.2.2
    parsers-0.12.12-ASMNvzJYM16NPhDEtW0Qz
    prettyprinter-1.7.1-CSlGZoOoBlWC7jpjoL7RBV
    prettyprinter-ansi-terminal-1.1.3-Jr4QPQoU3qM4H72wvTz5B6
    profunctors-5.6.3-10R90Ihs534GMDqp9RVxyK
    reducers-3.12.5-BOgspVOeDD4J0fuSUPWbfp transformers-0.5.6.2
    unordered-containers-0.2.20-C5ENqrDu1w64CLikkGEoYH
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

