#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 xcb-types
version:              0.15.0
visibility:           public
id:                   xcb-types-0.15.0-HIw3n37qHy923j0eWzIL5J
key:                  xcb-types-0.15.0-HIw3n37qHy923j0eWzIL5J
license:              BSD-3-Clause
maintainer:           Antoine Latter <aslatter@gmail.com>
author:               Antoine Latter
homepage:             http://community.haskell.org/~aslatter/code/xcb-types
synopsis:             Parses XML files used by the XCB project
description:
    This package provides types which mirror the structures
    used in the XCB code generation XML files.

    See project http://xcb.freedesktop.org/ for more information about the XCB
    project.

    The XML files describe the data-types, events and requests used by the
    X Protocol, and are used to auto-generate large parts of the XCB project.

    This package parses these XML files into Haskell data structures.

    If you want to do something with these XML descriptions but don'\''t want
    to learn XSLT, this package should help.

    This version of xcb-types is intended to fully parse the X Protocol
    description version 1.17.

category:             Data
abi:                  d7db15cb7f4208f6da648aa67bf79518
exposed:              True
exposed-modules:
    Data.XCB Data.XCB.FromXML Data.XCB.Pretty Data.XCB.Types

hidden-modules:       Data.XCB.Utils
import-dirs:          /usr/lib/ghc-9.4.8/site-local/xcb-types-0.15.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/xcb-types-0.15.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/xcb-types-0.15.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-xcb-types
hs-libraries:         HSxcb-types-0.15.0-HIw3n37qHy923j0eWzIL5J
depends:
    base-4.17.2.1 containers-0.6.7 mtl-2.2.2 pretty-1.1.3.6
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG

haddock-interfaces:   /usr/share/doc/haskell-xcb-types/html/xcb-types.haddock
haddock-html:         /usr/share/doc/haskell-xcb-types/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

