/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.state;

import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ModuleState {
    private WorkspaceModule module;
    private final Set<ArtifactCoords> platformBomImports = new LinkedHashSet<ArtifactCoords>(1);
    private final Map<ArtifactKey, TopExtensionDependency> directExtDeps = new LinkedHashMap<ArtifactKey, TopExtensionDependency>();
    private boolean main;

    public static Builder builder() {
        return new ModuleState().new Builder();
    }

    private ModuleState() {
    }

    public WorkspaceModuleId getId() {
        return this.module.getId();
    }

    public WorkspaceModule getWorkspaceModule() {
        return this.module;
    }

    public Path getModuleDir() {
        return this.module.getModuleDir().toPath();
    }

    public boolean isMain() {
        return this.main;
    }

    public Collection<ArtifactCoords> getPlatformBoms() {
        return this.platformBomImports;
    }

    public Collection<TopExtensionDependency> getExtensions() {
        return this.directExtDeps.values();
    }

    public boolean hasExtension(ArtifactKey key) {
        return this.directExtDeps.containsKey(key);
    }

    public class Builder {
        private Builder() {
        }

        public Builder setWorkspaceModule(WorkspaceModule module) {
            ModuleState.this.module = module;
            return this;
        }

        public Builder setMainModule(boolean main) {
            ModuleState.this.main = main;
            return this;
        }

        public Builder addPlatformBom(ArtifactCoords coords) {
            ModuleState.this.platformBomImports.add(coords);
            return this;
        }

        public Builder addExtensionDependency(TopExtensionDependency dep) {
            ModuleState.this.directExtDeps.put(dep.getKey(), dep);
            return this;
        }

        public ModuleState build() {
            return ModuleState.this;
        }
    }
}

