/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import org.jboss.resteasy.reactive.server.core.parameters.converters.TemporalParamConverter;

public class YearParamConverter
extends TemporalParamConverter<Year> {
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();

    public YearParamConverter() {
        super(PARSER);
    }

    public YearParamConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    protected Year convert(String value) {
        return Year.parse(value);
    }

    @Override
    protected Year convert(String value, DateTimeFormatter formatter) {
        return Year.parse(value, formatter);
    }

    public static class Supplier
    extends TemporalParamConverter.TemporalSupplier<YearParamConverter> {
        public Supplier() {
        }

        public Supplier(String pattern, String dateTimeFormatterProviderClassName) {
            super(pattern, dateTimeFormatterProviderClassName);
        }

        @Override
        protected YearParamConverter createConverter(DateTimeFormatter dateTimeFormatter) {
            return new YearParamConverter(dateTimeFormatter);
        }

        @Override
        public String getClassName() {
            return YearParamConverter.class.getName();
        }
    }
}

