/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmAggregateFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingSqmFunction<T>
extends SqmFunction<T> {
    private final @Nullable ReturnableType<T> impliedResultType;
    private final @Nullable ArgumentsValidator argumentsValidator;
    private final FunctionReturnTypeResolver returnTypeResolver;
    private final FunctionRenderer renderer;
    private @Nullable ReturnableType<?> resultType;

    public SelfRenderingSqmFunction(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<T> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(name, descriptor, nodeBuilder.resolveExpressible(impliedResultType), arguments, nodeBuilder);
        this.renderer = renderer;
        this.impliedResultType = impliedResultType;
        this.argumentsValidator = argumentsValidator;
        this.returnTypeResolver = returnTypeResolver;
    }

    @Override
    public SelfRenderingSqmFunction<T> copy(SqmCopyContext context) {
        SelfRenderingSqmFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        SelfRenderingSqmFunction<T> expression = context.registerCopy(this, new SelfRenderingSqmFunction<T>(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
        this.copyTo(expression, context);
        return expression;
    }

    public FunctionRenderer getFunctionRenderer() {
        return this.renderer;
    }

    protected @Nullable ReturnableType<T> getImpliedResultType() {
        return this.impliedResultType;
    }

    protected @Nullable ArgumentsValidator getArgumentsValidator() {
        return this.argumentsValidator;
    }

    protected FunctionReturnTypeResolver getReturnTypeResolver() {
        return this.returnTypeResolver;
    }

    protected List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        if (sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        FunctionArgumentTypeResolver argumentTypeResolver = this.getArgumentTypeResolver();
        return argumentTypeResolver == null ? SelfRenderingSqmFunction.collectArguments(sqmArguments, walker) : this.resolveArguments(sqmArguments, walker, argumentTypeResolver);
    }

    private List<SqlAstNode> resolveArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker, FunctionArgumentTypeResolver argumentTypeResolver) {
        FunctionArgumentTypeResolverTypeAccess typeAccess = new FunctionArgumentTypeResolverTypeAccess(walker, this, argumentTypeResolver);
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
        int size = sqmArguments.size();
        for (int i = 0; i < size; ++i) {
            typeAccess.argumentIndex = i;
            sqlAstArguments.add((SqlAstNode)walker.visitWithInferredType(sqmArguments.get(i), typeAccess));
        }
        return sqlAstArguments;
    }

    private static List<SqlAstNode> collectArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
        int size = sqmArguments.size();
        for (int i = 0; i < size; ++i) {
            sqlAstArguments.add((SqlAstNode)sqmArguments.get(i).accept(walker));
        }
        return sqlAstArguments;
    }

    private FunctionArgumentTypeResolver getArgumentTypeResolver() {
        FunctionArgumentTypeResolver functionArgumentTypeResolver;
        SqmFunctionDescriptor sqmFunctionDescriptor = this.getFunctionDescriptor();
        if (sqmFunctionDescriptor instanceof AbstractSqmFunctionDescriptor) {
            AbstractSqmFunctionDescriptor functionDescriptor = (AbstractSqmFunctionDescriptor)sqmFunctionDescriptor;
            functionArgumentTypeResolver = functionDescriptor.getArgumentTypeResolver();
        } else {
            functionArgumentTypeResolver = null;
        }
        return functionArgumentTypeResolver;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        @Nullable ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator validator = this.argumentsValidator;
        if (validator != null) {
            validator.validateSqlTypes(arguments, this.getFunctionName());
        }
        return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public @Nullable SqmBindableType<T> getNodeType() {
        SqmBindableType nodeType = super.getNodeType();
        if (nodeType == null) {
            SqmCriteriaNodeBuilder nodeBuilder = this.nodeBuilder();
            ReturnableType<?> resultType = this.determineResultType(null, nodeBuilder.getTypeConfiguration());
            if (resultType == null) {
                return null;
            }
            this.setExpressibleType(nodeBuilder.resolveExpressible(resultType));
            return super.getNodeType();
        }
        return nodeType;
    }

    public @Nullable ReturnableType<?> resolveResultType(SqmToSqlAstConverter walker) {
        if (this.resultType == null) {
            this.resultType = this.determineResultType(walker, walker.getCreationContext().getTypeConfiguration());
            if (this.resultType != null) {
                this.setExpressibleType(this.nodeBuilder().resolveExpressible(this.resultType));
            }
        }
        return this.resultType;
    }

    protected @Nullable ReturnableType<?> determineResultType(SqmToSqlAstConverter converter, TypeConfiguration typeConfiguration) {
        return this.returnTypeResolver.resolveFunctionReturnType(this.impliedResultType, converter, this.getArguments(), typeConfiguration);
    }

    protected MappingModelExpressible<?> getMappingModelExpressible(SqmToSqlAstConverter walker, ReturnableType<?> resultType, List<SqlAstNode> arguments) {
        if (resultType instanceof MappingModelExpressible) {
            MappingModelExpressible mappingModelExpressible = (MappingModelExpressible)((Object)resultType);
            return mappingModelExpressible;
        }
        MappingMetamodelImplementor mappingMetamodel = walker.getCreationContext().getMappingMetamodel();
        return this.returnTypeResolver.resolveFunctionReturnType(() -> {
            try {
                MappingModelExpressible<?> expressible = mappingMetamodel.resolveMappingExpressible(this.getNodeType(), walker.getFromClauseAccess()::getTableGroup);
                return (BasicValuedMapping)expressible;
            }
            catch (Exception e) {
                return null;
            }
        }, arguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SelfRenderingSqmAggregateFunction)) return false;
        SelfRenderingSqmAggregateFunction that = (SelfRenderingSqmAggregateFunction)other;
        if (!Objects.equals(this.toHqlString(), that.toHqlString())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.toHqlString().hashCode();
    }

    private static class FunctionArgumentTypeResolverTypeAccess
    implements Supplier<MappingModelExpressible<?>> {
        private final SqmToSqlAstConverter converter;
        private final SqmFunction<?> function;
        private final FunctionArgumentTypeResolver argumentTypeResolver;
        private int argumentIndex;

        public FunctionArgumentTypeResolverTypeAccess(SqmToSqlAstConverter converter, SqmFunction<?> function, FunctionArgumentTypeResolver argumentTypeResolver) {
            this.converter = converter;
            this.function = function;
            this.argumentTypeResolver = argumentTypeResolver;
        }

        @Override
        public MappingModelExpressible<?> get() {
            return this.argumentTypeResolver.resolveFunctionArgumentType(this.function.getArguments(), this.argumentIndex, this.converter);
        }
    }
}

