/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public class ConverterArchive
implements Diagnosable {
    private String m_izipName;
    private FileOutputStream m_ifStream = null;
    private ZipOutputStream m_izStream = null;
    private InputStream m_riStream = null;
    private ZipFile m_rzipFile = null;
    private static final String TEMPFILE = "gsstemp.zip";
    private static final String CLASS_NAME = ConverterArchive.class.getName();

    public void openArchiveforInsert(String zipName) {
        this.m_izipName = zipName;
        try {
            this.m_ifStream = new FileOutputStream(this.m_izipName);
            this.m_izStream = new ZipOutputStream(this.m_ifStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void closeArchiveforInsert() {
        try {
            this.m_izStream.close();
            this.m_ifStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void insertObj(Object obj, String entryName) {
        ZipEntry zEntry = null;
        ObjectOutputStream objStream = null;
        zEntry = new ZipEntry(entryName);
        try {
            this.m_izStream.putNextEntry(zEntry);
            objStream = new ObjectOutputStream(this.m_izStream);
            objStream.writeObject(obj);
            objStream.close();
            this.m_izStream.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void insertSingleObj(String zipName, Object obj, String entryName) throws IOException {
        block15: {
            FileInputStream fiStream = null;
            ZipInputStream ziStream = null;
            FileOutputStream foStream = null;
            ZipOutputStream zoStream = null;
            ZipEntry zEntry = null;
            ObjectInputStream oiStream = null;
            ObjectOutputStream ooStream = null;
            File targetZip = new File(zipName);
            if (targetZip.isFile()) {
                try {
                    fiStream = new FileInputStream(zipName);
                    ziStream = new ZipInputStream(fiStream);
                    foStream = new FileOutputStream(TEMPFILE);
                    zoStream = new ZipOutputStream(foStream);
                    while ((zEntry = ziStream.getNextEntry()) != null) {
                        if (zEntry.getName().equals(entryName)) continue;
                        zoStream.putNextEntry(zEntry);
                        oiStream = new ObjectInputStream(ziStream);
                        ooStream = new ObjectOutputStream(zoStream);
                        Object curobj = oiStream.readObject();
                        ooStream.writeObject(curobj);
                    }
                    zEntry = new ZipEntry(entryName);
                    zoStream.putNextEntry(zEntry);
                    ooStream = new ObjectOutputStream(zoStream);
                    ooStream.writeObject(obj);
                    ooStream.close();
                    ziStream.close();
                }
                catch (FileNotFoundException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (StreamCorruptedException ex) {
                    throw new IOException(ex.getMessage());
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (ClassNotFoundException ex) {
                    throw new IOException(ex.getMessage());
                }
                File tempZip = new File(TEMPFILE);
                targetZip.delete();
                try {
                    if (!tempZip.renameTo(targetZip)) {
                        throw new IOException("can't write to target file " + zipName);
                    }
                    break block15;
                }
                catch (SecurityException se) {
                    throw new IOException(se.getMessage());
                }
                catch (NullPointerException ne) {
                    throw new IOException(ne.getMessage());
                }
            }
            try {
                foStream = new FileOutputStream(zipName);
                zoStream = new ZipOutputStream(foStream);
                zEntry = new ZipEntry(entryName);
                zoStream.putNextEntry(zEntry);
                ooStream = new ObjectOutputStream(zoStream);
                ooStream.writeObject(obj);
                ooStream.close();
            }
            catch (FileNotFoundException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (StreamCorruptedException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (IOException ex) {
                throw ex;
            }
        }
        System.out.print(entryName + " has been successfully stored in ");
        System.out.println(zipName);
    }

    public void insertObjtoFile(String directory, String filename, Object obj) throws IOException {
        File dir = new File(directory);
        File file = new File(directory + filename);
        if (!dir.isDirectory()) {
            throw new IOException("directory " + directory + " doesn't exist");
        }
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (SecurityException ex) {
                throw new IOException("file exist, can't overwrite file.");
            }
        }
        try {
            FileOutputStream foStream = new FileOutputStream(file);
            ObjectOutputStream ooStream = new ObjectOutputStream(foStream);
            ooStream.writeObject(obj);
            ooStream.close();
        }
        catch (FileNotFoundException ex) {
            throw new IOException("file can't be created.");
        }
        System.out.print(filename + " has been successfully stored in ");
        System.out.println(directory);
    }

    public void openArchiveforRead() {
        try {
            this.m_rzipFile = new ZipFile(this.m_izipName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void closeArchiveforRead() {
        try {
            this.m_rzipFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObj(String entryName) {
        URL objfile = this.getClass().getResource(entryName);
        Object obj = null;
        ObjectInputStream objStream = null;
        InputStream iStream = null;
        if (objfile == null) {
            return null;
        }
        try {
            iStream = objfile.openStream();
            objStream = new ObjectInputStream(iStream);
            Object object = obj = objStream.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException ex) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "readObj", "Orai18n version mismatch {0}", (String)null, ex, (Object)ex.getMessage());
        }
        finally {
            try {
                if (objStream != null) {
                    objStream.close();
                }
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (IOException ea) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "readObj", "Got an exception while closing the stream: {0}", (String)null, ea, (Object)ea.getMessage());
            }
        }
        return null;
    }

    public Object readObj(String zipName, String entryName) {
        try {
            FileInputStream fiStream = new FileInputStream(zipName);
            ZipInputStream ziStream = new ZipInputStream(fiStream);
            ZipEntry zEntry = null;
            ObjectInputStream oiStream = null;
            Object obj = null;
            while (ziStream.available() != 0) {
                zEntry = ziStream.getNextEntry();
                if (zEntry == null || !zEntry.getName().equals(entryName)) continue;
                oiStream = new ObjectInputStream(ziStream);
                obj = oiStream.readObject();
                break;
            }
            ziStream.close();
            return obj;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

