/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.engine.states.creation;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.GetSnapshotsResult;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.State;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.creation.CreatingState;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.snapshots.ConcurrentSnapshotExecutionException;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ,\u0010\r\u001a\u00020\t2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0017\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreatingState;", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/State;", "<init>", "()V", "continuous", "", "getContinuous", "()Z", "execute", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMResult;", "context", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "snapshotName", "", "metadataBuilder", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;", "log", "Lorg/apache/logging/log4j/Logger;", "CONCURRENT_SNAPSHOT_MESSAGE", "getSnapshotCreationStartedMessage", "SNAPSHOT_ERROR_MESSAGE", "getCreateSnapshotErrorMessage", "checkCreatedSnapshots", "lastExecutionTime", "Ljava/time/Instant;", "snapshots", "", "Lorg/opensearch/snapshots/SnapshotInfo;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nCreatingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatingState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreatingState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1056#2:138\n*S KotlinDebug\n*F\n+ 1 CreatingState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreatingState\n*L\n126#1:138\n*E\n"})
public final class CreatingState
implements State {
    @NotNull
    public static final CreatingState INSTANCE = new CreatingState();
    private static final boolean continuous;
    @NotNull
    public static final String CONCURRENT_SNAPSHOT_MESSAGE = "Concurrent snapshot exception happened, retrying...";
    @NotNull
    private static final String SNAPSHOT_ERROR_MESSAGE = "Caught exception while getting snapshots to decide if snapshot has been created in previous execution period.";

    private CreatingState() {
    }

    @Override
    public boolean getContinuous() {
        return continuous;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull SMStateMachine context, @NotNull Continuation<? super SMResult> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                /* synthetic */ Object result;
                final /* synthetic */ CreatingState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((SMStateMachine)null, (Continuation<? super SMResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                client = context.getClient();
                job = context.getJob();
                metadata = context.getMetadata();
                log = context.getLog();
                metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.CREATION);
                v0 = metadata.getCreation().getStarted();
                v1 = snapshotName = v0 != null ? (String)CollectionsKt.first(v0) : null;
                if (snapshotName != null) ** GOTO lbl55
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = client;
                $continuation.L$2 = job;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                $continuation.L$4 = log;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)metadataBuilder);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)snapshotName);
                $continuation.label = 1;
                v2 = SMUtilsKt.getSnapshots(client, job, job.getPolicyName() + "*", metadataBuilder, log, null, "Caught exception while getting snapshots to decide if snapshot has been created in previous execution period.", (Continuation<? super GetSnapshotsResult>)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl42
            }
            case 1: {
                snapshotName = (String)$continuation.L$6;
                metadataBuilder = (SMMetadata.Builder)$continuation.L$5;
                log = (Logger)$continuation.L$4;
                metadata = (SMMetadata)$continuation.L$3;
                job = (SMPolicy)$continuation.L$2;
                client = (Client)$continuation.L$1;
                context = (SMStateMachine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                getSnapshotsResult = (GetSnapshotsResult)v2;
                metadataBuilder = getSnapshotsResult.getMetadataBuilder();
                if (getSnapshotsResult.getFailed()) {
                    return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION, null, 4, null);
                }
                getSnapshots = getSnapshotsResult.getSnapshots();
                latestExecutionStartTime = (Instant)job.getCreation().getSchedule().getPeriodStartingAt(null).v1();
                Intrinsics.checkNotNull((Object)latestExecutionStartTime);
                snapshotName = this.checkCreatedSnapshots(latestExecutionStartTime, getSnapshots);
                if (snapshotName != null) {
                    log.info("Already created snapshot [" + snapshotName + "] during this execution period starting at " + latestExecutionStartTime + ".");
                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.IN_PROGRESS, false, null, false, null, null, 62, null).setCreationStarted(snapshotName);
                    return new SMResult.Next(metadataBuilder);
                }
lbl55:
                // 3 sources

                snapshotName = SMUtilsKt.generateSnapshotName(job);
                v3 = job.getSnapshotConfig().get("repository");
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.String");
                req = new CreateSnapshotRequest((String)v3, snapshotName).source(SMUtilsKt.addSMPolicyInSnapshotMetadata(job.getSnapshotConfig(), job.getPolicyName())).waitForCompletion(false);
                v4 = client.admin().cluster();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"cluster(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)job);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                $continuation.L$4 = log;
                $continuation.L$5 = metadataBuilder;
                $continuation.L$6 = snapshotName;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)req);
                $continuation.label = 2;
                v5 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)v4, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, execute$lambda$0(org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest org.opensearch.transport.client.ClusterAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/ClusterAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((CreateSnapshotRequest)req), $continuation);
                ** if (v5 != var14_5) goto lbl75
lbl74:
                // 1 sources

                return var14_5;
lbl75:
                // 1 sources

                ** GOTO lbl89
            }
            case 2: {
                req = (CreateSnapshotRequest)$continuation.L$7;
                snapshotName = (String)$continuation.L$6;
                metadataBuilder = (SMMetadata.Builder)$continuation.L$5;
                log = (Logger)$continuation.L$4;
                metadata = (SMMetadata)$continuation.L$3;
                job = (SMPolicy)$continuation.L$2;
                client = (Client)$continuation.L$1;
                context = (SMStateMachine)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl89:
                    // 2 sources

                    SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.IN_PROGRESS, false, this.getSnapshotCreationStartedMessage(snapshotName), false, null, null, 58, null).setCreationStarted(snapshotName);
                }
                catch (RemoteTransportException ex) {
                    v6 = ExceptionsHelper.unwrapCause((Throwable)ex);
                    Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v6;
                    return this.handleException(unwrappedException, snapshotName, metadataBuilder, log);
                }
                catch (Exception ex) {
                    return this.handleException(ex, snapshotName, metadataBuilder, log);
                }
                return new SMResult.Next(metadataBuilder);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SMResult handleException(Exception ex, String snapshotName, SMMetadata.Builder metadataBuilder, Logger log) {
        if (ex instanceof ConcurrentSnapshotExecutionException) {
            log.error(CONCURRENT_SNAPSHOT_MESSAGE, (Throwable)ex);
            SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, CONCURRENT_SNAPSHOT_MESSAGE, false, null, null, 58, null);
            return new SMResult.Stay(metadataBuilder);
        }
        log.error(this.getCreateSnapshotErrorMessage(snapshotName), (Throwable)ex);
        SMMetadata.Builder.setLatestExecution$default(metadataBuilder, SMMetadata.LatestExecution.Status.RETRYING, false, this.getCreateSnapshotErrorMessage(snapshotName), false, ex, null, 42, null);
        return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION, null, 4, null);
    }

    private final String getSnapshotCreationStartedMessage(String snapshotName) {
        return "Snapshot " + snapshotName + " creation has been started and waiting for completion.";
    }

    private final String getCreateSnapshotErrorMessage(String snapshotName) {
        return "Caught exception while creating snapshot " + snapshotName + ".";
    }

    private final String checkCreatedSnapshots(Instant lastExecutionTime, List<SnapshotInfo> snapshots) {
        if (snapshots.isEmpty()) {
            return null;
        }
        Iterable $this$sortedBy$iv = snapshots;
        boolean $i$f$sortedBy = false;
        int n = ((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SnapshotInfo it = (SnapshotInfo)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.startTime());
                it = (SnapshotInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.startTime()));
            }
        })).size() + -1;
        if (0 <= n) {
            int i;
            return !Instant.ofEpochMilli(snapshots.get(i = n--).startTime()).isBefore(lastExecutionTime) ? snapshots.get(i).snapshotId().getName() : null;
        }
        return null;
    }

    private static final Unit execute$lambda$0(CreateSnapshotRequest $req, ClusterAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.createSnapshot($req, it);
        return Unit.INSTANCE;
    }
}

