/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import lombok.Generated;
import org.opensearch.core.common.Strings;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;

public final class OriginalMappingParameters {
    private final VectorDataType vectorDataType;
    private final int dimension;
    private final KNNMethodContext knnMethodContext;
    private KNNMethodContext resolvedKnnMethodContext;
    private final String mode;
    private final String compressionLevel;
    private final String modelId;
    private final String topLevelSpaceType;

    public OriginalMappingParameters(KNNVectorFieldMapper.Builder builder) {
        this.vectorDataType = (VectorDataType)((Object)builder.vectorDataType.get());
        this.knnMethodContext = (KNNMethodContext)builder.knnMethodContext.get();
        this.resolvedKnnMethodContext = (KNNMethodContext)builder.knnMethodContext.get();
        this.dimension = (Integer)builder.dimension.get();
        this.mode = (String)builder.mode.get();
        this.compressionLevel = (String)builder.compressionLevel.get();
        this.modelId = (String)builder.modelId.get();
        this.topLevelSpaceType = (String)builder.topLevelSpaceType.get();
    }

    public boolean isLegacyMapping() {
        if (this.knnMethodContext != null) {
            return false;
        }
        if (this.modelId != null) {
            return false;
        }
        return Strings.isEmpty((CharSequence)this.mode) && Strings.isEmpty((CharSequence)this.compressionLevel);
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public KNNMethodContext getKnnMethodContext() {
        return this.knnMethodContext;
    }

    @Generated
    public KNNMethodContext getResolvedKnnMethodContext() {
        return this.resolvedKnnMethodContext;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getCompressionLevel() {
        return this.compressionLevel;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getTopLevelSpaceType() {
        return this.topLevelSpaceType;
    }

    @Generated
    public OriginalMappingParameters(VectorDataType vectorDataType, int dimension, KNNMethodContext knnMethodContext, String mode, String compressionLevel, String modelId, String topLevelSpaceType) {
        this.vectorDataType = vectorDataType;
        this.dimension = dimension;
        this.knnMethodContext = knnMethodContext;
        this.mode = mode;
        this.compressionLevel = compressionLevel;
        this.modelId = modelId;
        this.topLevelSpaceType = topLevelSpaceType;
    }

    @Generated
    public void setResolvedKnnMethodContext(KNNMethodContext resolvedKnnMethodContext) {
        this.resolvedKnnMethodContext = resolvedKnnMethodContext;
    }
}

