/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.FilterFieldType;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.neuralsearch.mapper.dto.ChunkingConfig;
import org.opensearch.neuralsearch.mapper.dto.SemanticParameters;
import org.opensearch.neuralsearch.mapper.dto.SparseEncodingConfig;
import org.opensearch.neuralsearch.processor.chunker.ChunkerValidatorFactory;

public class SemanticFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "semantic";
    private final SemanticParameters semanticParameters;
    private ParametrizedFieldMapper delegateFieldMapper;

    protected SemanticFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, ParametrizedFieldMapper delegateFieldMapper, SemanticParameters semanticParameters) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.delegateFieldMapper = delegateFieldMapper;
        this.semanticParameters = semanticParameters;
    }

    public Builder getMergeBuilder() {
        Builder semanticFieldMapperBuilder = (Builder)new Builder(this.simpleName()).init((FieldMapper)this);
        ParametrizedFieldMapper.Builder delegateBuilder = this.delegateFieldMapper.getMergeBuilder();
        semanticFieldMapperBuilder.setDelegateBuilder(delegateBuilder);
        return semanticFieldMapperBuilder;
    }

    public final ParametrizedFieldMapper merge(Mapper mergeWith) {
        if (mergeWith instanceof SemanticFieldMapper) {
            try {
                this.delegateFieldMapper = this.delegateFieldMapper.merge((Mapper)((SemanticFieldMapper)mergeWith).delegateFieldMapper);
            }
            catch (IllegalArgumentException e) {
                String err = String.format(Locale.ROOT, "Failed to update the mapper %s because failed to update the delegate mapper for the raw_field_type %s due to %s", this.name(), this.semanticParameters.getRawFieldType(), e.getMessage());
                throw new IllegalArgumentException(err, e);
            }
        }
        return super.merge(mergeWith);
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        this.delegateFieldMapper.parse(context);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        List<ParametrizedFieldMapper.Parameter<?>> parameters = this.getMergeBuilder().getParameters();
        for (ParametrizedFieldMapper.Parameter<?> parameter : parameters) {
            if ("raw_field_type".equals(parameter.name)) {
                parameter.toXContent(builder, true);
                continue;
            }
            parameter.toXContent(builder, includeDefaults);
        }
        this.delegateFieldMapper.multiFields().toXContent(builder, params);
        this.delegateFieldMapper.copyTo().toXContent(builder, params);
        this.delegateFieldMapper.getMergeBuilder().toXContent(builder, includeDefaults);
    }

    @Generated
    public void setDelegateFieldMapper(ParametrizedFieldMapper delegateFieldMapper) {
        this.delegateFieldMapper = delegateFieldMapper;
    }

    @Generated
    public ParametrizedFieldMapper getDelegateFieldMapper() {
        return this.delegateFieldMapper;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected final ParametrizedFieldMapper.Parameter<String> modelId = ParametrizedFieldMapper.Parameter.stringParam((String)"model_id", (boolean)true, m -> ((SemanticFieldMapper)m).semanticParameters.getModelId(), null);
        protected final ParametrizedFieldMapper.Parameter<String> searchModelId = ParametrizedFieldMapper.Parameter.stringParam((String)"search_model_id", (boolean)true, m -> ((SemanticFieldMapper)m).semanticParameters.getSearchModelId(), null);
        protected final ParametrizedFieldMapper.Parameter<String> rawFieldType = ParametrizedFieldMapper.Parameter.stringParam((String)"raw_field_type", (boolean)false, m -> ((SemanticFieldMapper)m).semanticParameters.getRawFieldType(), (String)"text");
        protected final ParametrizedFieldMapper.Parameter<String> semanticInfoFieldName = ParametrizedFieldMapper.Parameter.stringParam((String)"semantic_info_field_name", (boolean)false, m -> ((SemanticFieldMapper)m).semanticParameters.getSemanticInfoFieldName(), null);
        protected final ParametrizedFieldMapper.Parameter<ChunkingConfig> chunkingConfig = new ParametrizedFieldMapper.Parameter("chunking", false, () -> null, (name, ctx, value) -> new ChunkingConfig((String)name, value, new ChunkerValidatorFactory()), m -> ((SemanticFieldMapper)m).semanticParameters.getChunkingConfig()).setSerializer((builder, name, value) -> {
            if (value == null) {
                builder.nullField(name);
            } else {
                value.toXContent(builder, name);
            }
        }, value -> value == null ? null : value.toString());
        protected final ParametrizedFieldMapper.Parameter<String> semanticFieldSearchAnalyzer = ParametrizedFieldMapper.Parameter.stringParam((String)"semantic_field_search_analyzer", (boolean)true, m -> ((SemanticFieldMapper)m).semanticParameters.getSemanticFieldSearchAnalyzer(), null);
        protected final ParametrizedFieldMapper.Parameter<Map<String, Object>> denseEmbeddingConfig = new ParametrizedFieldMapper.Parameter("dense_embedding_config", false, () -> null, (name, ctx, o) -> {
            if (o == null) {
                return null;
            }
            if (o instanceof Map) {
                return (Map)o;
            }
            throw new MapperParsingException("[dense_embedding_config] must be an object");
        }, m -> ((SemanticFieldMapper)m).semanticParameters.getDenseEmbeddingConfig()).setSerializer((builder, name, value) -> {
            if (value == null) {
                builder.nullField(name);
            } else {
                builder.startObject(name);
                builder.mapContents(value);
                builder.endObject();
            }
        }, v -> v == null ? null : v.toString());
        protected final ParametrizedFieldMapper.Parameter<SparseEncodingConfig> sparseEncodingConfig = new ParametrizedFieldMapper.Parameter("sparse_encoding_config", false, () -> null, (name, ctx, value) -> new SparseEncodingConfig((String)name, value), m -> ((SemanticFieldMapper)m).semanticParameters.getSparseEncodingConfig()).setSerializer((builder, name, value) -> {
            if (value == null) {
                builder.nullField(name);
            } else {
                value.toXContent(builder, name);
            }
        }, value -> value == null ? null : value.toString());
        protected final ParametrizedFieldMapper.Parameter<Boolean> skipExistingEmbedding = ParametrizedFieldMapper.Parameter.boolParam((String)"skip_existing_embedding", (boolean)true, m -> ((SemanticFieldMapper)m).semanticParameters.getSkipExistingEmbedding(), (boolean)false);
        protected ParametrizedFieldMapper.Builder delegateBuilder;

        protected Builder(String name2) {
            super(name2);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return List.of(this.modelId, this.searchModelId, this.rawFieldType, this.semanticInfoFieldName, this.chunkingConfig, this.semanticFieldSearchAnalyzer, this.denseEmbeddingConfig, this.sparseEncodingConfig, this.skipExistingEmbedding);
        }

        public SemanticFieldMapper build(Mapper.BuilderContext context) {
            ParametrizedFieldMapper delegateMapper = this.delegateBuilder.build(context);
            SemanticParameters semanticParameters = this.getSemanticParameters();
            SemanticFieldType semanticFieldType = new SemanticFieldType(delegateMapper.fieldType(), semanticParameters);
            return new SemanticFieldMapper(this.name, (MappedFieldType)semanticFieldType, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), delegateMapper, semanticParameters);
        }

        public SemanticParameters getSemanticParameters() {
            return SemanticParameters.builder().modelId((String)this.modelId.getValue()).searchModelId((String)this.searchModelId.getValue()).rawFieldType((String)this.rawFieldType.getValue()).semanticInfoFieldName((String)this.semanticInfoFieldName.getValue()).chunkingConfig((ChunkingConfig)this.chunkingConfig.getValue()).semanticFieldSearchAnalyzer((String)this.semanticFieldSearchAnalyzer.getValue()).denseEmbeddingConfig((Map)this.denseEmbeddingConfig.getValue()).sparseEncodingConfig((SparseEncodingConfig)this.sparseEncodingConfig.getValue()).skipExistingEmbedding((Boolean)this.skipExistingEmbedding.getValue()).build();
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getModelId() {
            return this.modelId;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getSearchModelId() {
            return this.searchModelId;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getRawFieldType() {
            return this.rawFieldType;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<String> getSemanticInfoFieldName() {
            return this.semanticInfoFieldName;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<ChunkingConfig> getChunkingConfig() {
            return this.chunkingConfig;
        }

        @Generated
        public ParametrizedFieldMapper.Parameter<Boolean> getSkipExistingEmbedding() {
            return this.skipExistingEmbedding;
        }

        @Generated
        public void setDelegateBuilder(ParametrizedFieldMapper.Builder delegateBuilder) {
            this.delegateBuilder = delegateBuilder;
        }
    }

    public static class SemanticFieldType
    extends FilterFieldType {
        private SemanticParameters semanticParameters;

        public SemanticFieldType(@NonNull MappedFieldType delegate, @NonNull SemanticParameters semanticParameters) {
            super(delegate);
            Objects.requireNonNull(delegate, "delegate is marked non-null but is null");
            Objects.requireNonNull(semanticParameters, "semanticParameters is marked non-null but is null");
            this.semanticParameters = semanticParameters;
        }

        public String typeName() {
            return SemanticFieldMapper.CONTENT_TYPE;
        }

        public String getSemanticInfoFieldPath() {
            CharSequence[] paths = this.name().split("\\.");
            String semanticInfoFieldName = this.semanticParameters.getSemanticInfoFieldName();
            paths[paths.length - 1] = semanticInfoFieldName == null ? (String)paths[paths.length - 1] + "_semantic_info" : semanticInfoFieldName;
            return String.join((CharSequence)".", paths);
        }

        @Generated
        public SemanticParameters getSemanticParameters() {
            return this.semanticParameters;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private static final Set<String> SUPPORTED_RAW_FIELD_TYPE = Set.of("text", "keyword", "match_only_text", "wildcard", "token_count", "binary");

        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            String rawFieldType = (String)node.getOrDefault("raw_field_type", "text");
            String searchModelId = node.getOrDefault("search_model_id", null);
            String semanticFieldSearchAnalyzer = node.getOrDefault("semantic_field_search_analyzer", null);
            this.validateRawFieldType(rawFieldType);
            this.validateSearchModelIdAndSemanticFieldSearchAnalyzer(searchModelId, semanticFieldSearchAnalyzer, name);
            ParametrizedFieldMapper.TypeParser typeParser = (ParametrizedFieldMapper.TypeParser)parserContext.typeParser(rawFieldType);
            Builder semanticFieldMapperBuilder = new Builder(name);
            Map<String, Object> semanticConfig = this.extractSemanticConfig(node, semanticFieldMapperBuilder.getParameters(), rawFieldType);
            semanticFieldMapperBuilder.parse(name, parserContext, semanticConfig);
            ParametrizedFieldMapper.Builder delegateBuilder = typeParser.parse(name, node, parserContext);
            semanticFieldMapperBuilder.setDelegateBuilder(delegateBuilder);
            return semanticFieldMapperBuilder;
        }

        private void validateRawFieldType(String rawFieldType) {
            if (rawFieldType == null || !SUPPORTED_RAW_FIELD_TYPE.contains(rawFieldType)) {
                String err = String.format(Locale.ROOT, "raw_field_type %s is not supported. It should be one of [%s]", rawFieldType, String.join((CharSequence)", ", SUPPORTED_RAW_FIELD_TYPE));
                throw new IllegalArgumentException(err);
            }
        }

        private void validateSearchModelIdAndSemanticFieldSearchAnalyzer(String searchModelId, String semanticFieldSearchAnalyzer, String name) {
            if (searchModelId != null && semanticFieldSearchAnalyzer != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s can not coexist with %s in semantic field %s", "search_model_id", "semantic_field_search_analyzer", name));
            }
            if (searchModelId != null && searchModelId.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s can not be empty string in semantic field %s", "search_model_id", name));
            }
            if (semanticFieldSearchAnalyzer != null && semanticFieldSearchAnalyzer.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s can not be empty string in semantic field %s", "semantic_field_search_analyzer", name));
            }
        }

        private Map<String, Object> extractSemanticConfig(Map<String, Object> node, List<ParametrizedFieldMapper.Parameter<?>> parameters, String rawFieldType) {
            HashMap<String, Object> semanticConfig = new HashMap<String, Object>();
            for (ParametrizedFieldMapper.Parameter<?> parameter : parameters) {
                Object config = node.get(parameter.name);
                if (config == null) continue;
                semanticConfig.put(parameter.name, config);
                node.remove(parameter.name);
            }
            semanticConfig.put("type", SemanticFieldMapper.CONTENT_TYPE);
            node.put("type", rawFieldType);
            return semanticConfig;
        }
    }
}

