/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;

public class AlgorithmPolicyParameters {
    @Nonnull
    private Collection<String> includedAlgorithmURIs = CollectionSupport.emptySet();
    @Nonnull
    private Collection<String> excludedAlgorithmURIs = CollectionSupport.emptySet();

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getIncludedAlgorithms() {
        return this.includedAlgorithmURIs;
    }

    public void setIncludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.includedAlgorithmURIs = CollectionSupport.emptySet();
            return;
        }
        this.includedAlgorithmURIs = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(uris));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<String> getExcludedAlgorithms() {
        return this.excludedAlgorithmURIs;
    }

    public void setExcludedAlgorithms(@Nullable Collection<String> uris) {
        if (uris == null) {
            this.excludedAlgorithmURIs = CollectionSupport.emptySet();
            return;
        }
        this.excludedAlgorithmURIs = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(uris));
    }
}

