#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-IexhZRQaMtTGuhVFUxEi9d
key:                  postgrest-10.0.0-IexhZRQaMtTGuhVFUxEi9d
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  48760380a2bb26fef59d9033476db50b
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-IexhZRQaMtTGuhVFUxEi9d
depends:
    HTTP-4000.4.1-9WNcGHxwV7oIgnHvMHz59n
    Ranged-sets-0.5.0-AI3zud9q18r1F22t5JYm78
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j
    auto-update-0.1.6-4130TMPnIqX6bIh71QvxWp base-4.17.2.1
    base64-bytestring-1.2.1.0-AW9I0WOkr0IYZNZquGJUP bytestring-0.11.5.3
    case-insensitive-1.2.1.0-Fpgl4YyjrVl4Gttb0PploH
    cassava-0.5.4.1-GPQQhDLzAO46yO6C4JVUrL
    configurator-pg-0.2.10-LVc5i1RXAaFgHc3u7ycQN containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-9trvXhSocPAD0MDHslM6Mi
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-FTg6CRzcJ2kIqvu5X6iIUJ
    hasql-dynamic-statements-0.3.1.1-ECvB0ytVC9L5q1NduuA3ET
    hasql-notifications-0.2.0.5-AOyNZeMVexZEpPH46Bv4ub
    hasql-pool-0.5.2.2-F8Czi8wOjgeBb73aUWxGwf
    hasql-transaction-1.0.1.1-Hg87TmTTvp28aahuSEu87G
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-8HR0lcMpUwL4edtlDqx8uG
    insert-ordered-containers-0.2.5.3-E6tYgOUDlK1HVRGkBx47qE
    interpolatedstring-perl6-1.0.2-A1Y7Hy021tDExY0DUieWwB
    jose-0.10-CdSaEzE49uVLrokIwuUxh lens-5.3.2-5iQf9T9ZD7E1oav0YIbKON
    lens-aeson-1.2.3-H7IaeUX0Idy73tD4i0PSNK mtl-2.2.2
    network-3.1.4.0-4UbSgXPdAp7DQ7Pftr1aPB
    network-uri-2.6.4.2-IKG3zvKYtEQ3q1XygxFZnU
    optparse-applicative-0.18.1.0-7S1OQWk23vFFb1lO3AOVmW
    parsec-3.1.16.1 protolude-0.3.5-1JLvbLt9PpS92S9V8llbCo
    regex-tdfa-1.3.2.4-L830ITFBELiAQQMup0x7Sq
    retry-0.9.3.1-dDPvcBtiD9DgXdkKCzvkz
    scientific-0.3.8.0-DVR29LrvvAIAHP7TdQIZgA
    swagger2-2.8.10-EvLb2TurZjFNbip6Q70r0 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-C5ENqrDu1w64CLikkGEoYH
    vault-0.3.1.5-AgnXc00klW2H4jZnXS8V8g
    vector-0.13.2.0-o0y58FfPZzKSAM3ADJGlg
    wai-3.2.4-54grchYoKyyD66je19YTSn
    wai-cors-0.2.7-2SU4PaVUZN0Jz8TLNIBqee
    wai-extra-3.1.18-A3StP8Fsv6ZKkPTrNgjMD3
    wai-logger-2.5.0-L9iqIrAc33B4FOWjpkJ5kB
    warp-3.3.31-KE5H9mDCEjAKQ3W6oJRFhX

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

