/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.util.Iterator;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ArrowBuf;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compare.VectorVisitor;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public abstract class ExtensionTypeVector<T extends ValueVector & FieldVector>
extends BaseValueVector
implements FieldVector {
    private final T underlyingVector;
    private final String name;

    public ExtensionTypeVector(String name, BufferAllocator allocator, T underlyingVector) {
        super(allocator);
        Preconditions.checkNotNull(underlyingVector, "underlyingVector cannot be null.");
        this.name = name;
        this.underlyingVector = underlyingVector;
    }

    public ExtensionTypeVector(Field field, BufferAllocator allocator, T underlyingVector) {
        this(field.getName(), allocator, underlyingVector);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T getUnderlyingVector() {
        return this.underlyingVector;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.underlyingVector.allocateNew();
    }

    @Override
    public boolean allocateNewSafe() {
        return this.underlyingVector.allocateNewSafe();
    }

    @Override
    public void reAlloc() {
        this.underlyingVector.reAlloc();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.underlyingVector.setInitialCapacity(numRecords);
    }

    @Override
    public int getValueCapacity() {
        return this.underlyingVector.getValueCapacity();
    }

    @Override
    public void reset() {
        this.underlyingVector.reset();
    }

    @Override
    public Field getField() {
        return this.underlyingVector.getField();
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.EXTENSIONTYPE;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.underlyingVector.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.underlyingVector.getTransferPair(ref, allocator, callBack);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.underlyingVector.getTransferPair(field, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return this.underlyingVector.getTransferPair(field, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return this.underlyingVector.makeTransferPair(target);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return this.underlyingVector.getReader();
    }

    @Override
    public int getBufferSize() {
        return this.underlyingVector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return this.underlyingVector.getBufferSizeFor(valueCount);
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        return this.underlyingVector.getBuffers(clear);
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.underlyingVector.getValidityBuffer();
    }

    @Override
    public ArrowBuf getDataBuffer() {
        return this.underlyingVector.getDataBuffer();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        return this.underlyingVector.getOffsetBuffer();
    }

    @Override
    public int getValueCount() {
        return this.underlyingVector.getValueCount();
    }

    @Override
    public void setValueCount(int valueCount) {
        this.underlyingVector.setValueCount(valueCount);
    }

    @Override
    public abstract Object getObject(int var1);

    @Override
    public int getNullCount() {
        return this.underlyingVector.getNullCount();
    }

    @Override
    public boolean isNull(int index) {
        return this.underlyingVector.isNull(index);
    }

    @Override
    public void setNull(int index) {
        ((FieldVector)this.underlyingVector).setNull(index);
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        ((FieldVector)this.underlyingVector).initializeChildrenFromFields(children);
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return ((FieldVector)this.underlyingVector).getChildrenFromFields();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        ((FieldVector)this.underlyingVector).loadFieldBuffers(fieldNode, ownBuffers);
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        return ((FieldVector)this.underlyingVector).getFieldBuffers();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        return ((FieldVector)this.underlyingVector).getFieldInnerVectors();
    }

    @Override
    public long getValidityBufferAddress() {
        return ((FieldVector)this.underlyingVector).getValidityBufferAddress();
    }

    @Override
    public long getDataBufferAddress() {
        return ((FieldVector)this.underlyingVector).getDataBufferAddress();
    }

    @Override
    public long getOffsetBufferAddress() {
        return ((FieldVector)this.underlyingVector).getOffsetBufferAddress();
    }

    @Override
    public void clear() {
        this.underlyingVector.clear();
    }

    @Override
    public void close() {
        this.underlyingVector.close();
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.underlyingVector.getTransferPair(allocator);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.underlyingVector.iterator();
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.underlyingVector.getAllocator();
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }
}

