/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.string.StringFormat;

final class RoutineExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(RoutineExtRetriever.class.getName());

    RoutineExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveRoutineInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ROUTINES)) {
            LOGGER.log(Level.INFO, "Not retrieving routine definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Routine definition SQL statement was not provided");
            return;
        }
        Query routineDefinitionsSql = informationSchemaViews.getQuery(InformationSchemaKey.ROUTINES);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.routinesRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving additional routine information, using fast data dictionary retrieval over schemas");
                this.retrieveRoutineInformationOverSchemas(routineDefinitionsSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving additional routine information, using fast data dictionary retrieval");
                this.retrieveRoutineInformationFromDataDictionary(routineDefinitionsSql);
            }
        }
    }

    void retrieveRoutineReferences() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ROUTINE_REFERENCES)) {
            LOGGER.log(Level.INFO, "Not retrieving routine references, since this was not requested");
            LOGGER.log(Level.FINE, "Routine references SQL statement was not provided");
            return;
        }
        Query routineReferencesSql = informationSchemaViews.getQuery(InformationSchemaKey.ROUTINE_REFERENCES);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.routineReferencesRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving routine references, using fast data dictionary retrieval over schemas");
                this.retrieveRoutineReferencesOverSchemas(routineReferencesSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving routine references, using fast data dictionary retrieval");
                this.retrieveRoutineReferencesFromDataDictionary(routineReferencesSql);
            }
        }
    }

    private boolean addRoutineInformation(MetadataResultSet results) throws SQLException {
        String specificName;
        String routineName;
        String schemaName;
        String catalogName = this.normalizeCatalogName(results.getString("ROUTINE_CATALOG"));
        Optional<MutableRoutine> routineOptional = this.lookupRoutine(catalogName, schemaName = this.normalizeSchemaName(results.getString("ROUTINE_SCHEMA")), routineName = results.getString("ROUTINE_NAME"), specificName = results.getString("SPECIFIC_NAME"));
        if (routineOptional.isPresent()) {
            MutableRoutine routine = routineOptional.get();
            LOGGER.log(Level.FINER, new StringFormat("Retrieving routine information for <%s>", routineName));
            RoutineBodyType routineBodyType = results.getEnum("ROUTINE_BODY", RoutineBodyType.unknown);
            String definition = results.getString("ROUTINE_DEFINITION");
            routine.setRoutineBodyType(routineBodyType);
            routine.setDefinition(definition);
            routine.addAttributes(results.getAttributes());
        }
        return routineOptional.isPresent();
    }

    private boolean addRoutineReferences(MetadataResultSet results) throws SQLException {
        String catalogName = this.normalizeCatalogName(results.getString("ROUTINE_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("ROUTINE_SCHEMA"));
        String routineName = results.getString("ROUTINE_NAME");
        String specificName = results.getString("SPECIFIC_NAME");
        String referencedObjectCatalogName = results.getString("REFERENCED_OBJECT_CATALOG");
        String referencedObjectSchemaName = results.getString("REFERENCED_OBJECT_SCHEMA");
        String referencedObjectName = results.getString("REFERENCED_OBJECT_NAME");
        Optional<MutableRoutine> routineOptional = this.lookupRoutine(catalogName, schemaName, routineName, specificName);
        if (routineOptional.isPresent()) {
            MutableRoutine routine = routineOptional.get();
            LOGGER.log(Level.FINER, new StringFormat("Retrieving routine references for <%s>", routineName));
            Optional<DatabaseObject> referencedObjectOptional = this.lookupReferencedObject(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName, specificName);
            if (referencedObjectOptional.isPresent()) {
                routine.addReferencedObject(referencedObjectOptional.get());
            }
            return referencedObjectOptional.isPresent();
        }
        return false;
    }

    private Optional<DatabaseObject> lookupReferencedObject(String catalogName, String schemaName, String objectName, String specificName) {
        Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, objectName);
        if (tableOptional.isPresent()) {
            return Optional.of((DatabaseObject)tableOptional.get());
        }
        this.lookupRoutine(catalogName, schemaName, objectName, specificName);
        if (tableOptional.isPresent()) {
            return Optional.of((DatabaseObject)tableOptional.get());
        }
        return Optional.empty();
    }

    private void retrieveRoutineInformationFromDataDictionary(Query routineDefinitionsSql) throws SQLException {
        String name = "routine definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("routine definitions");
        try (Connection connection = this.getRetrieverConnection().getConnection("routine definitions");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(routineDefinitionsSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean addedRoutineInformation = this.addRoutineInformation(results);
                retrievalCounts.countIfIncluded(addedRoutineInformation);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve routine definitions", e);
        }
        retrievalCounts.log();
    }

    private void retrieveRoutineInformationOverSchemas(Query routineDefinitionsSql) throws SQLException {
        String name = "routine definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("routine definitions");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getRoutines(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("routine definitions");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(routineDefinitionsSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean addedRoutineInformation = this.addRoutineInformation(results);
                    retrievalCounts.countIfIncluded(schema.key(), addedRoutineInformation);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Could not retrieve routine definitions for schema <%s>", schema), e);
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }

    private void retrieveRoutineReferencesFromDataDictionary(Query routineReferencesSql) throws SQLException {
        String name = "routine references";
        RetrievalCounts retrievalCounts = new RetrievalCounts("routine references");
        try (Connection connection = this.getRetrieverConnection().getConnection("routine references");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(routineReferencesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean addedRoutineReferences = this.addRoutineReferences(results);
                retrievalCounts.countIfIncluded(addedRoutineReferences);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve routine definitions", e);
        }
        retrievalCounts.log();
    }

    private void retrieveRoutineReferencesOverSchemas(Query routineReferencesSql) throws SQLException {
        String name = "routine references";
        RetrievalCounts retrievalCounts = new RetrievalCounts("routine references");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getRoutines(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("routine references");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(routineReferencesSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean addedRoutineReferences = this.addRoutineReferences(results);
                    retrievalCounts.countIfIncluded(schema.key(), addedRoutineReferences);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, new StringFormat("Could not retrieve routine references for schema <%s>", schema));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

