/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.wire.FbWireService;
import org.firebirdsql.gds.ng.wire.ProtocolCollection;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireConnection;

public class WireServiceConnection
extends WireConnection<IServiceProperties, FbWireService> {
    public WireServiceConnection(IServiceProperties serviceProperties) throws SQLException {
        super(serviceProperties);
    }

    public WireServiceConnection(IServiceProperties serviceProperties, IEncodingFactory encodingFactory, ProtocolCollection protocols) throws SQLException {
        super(serviceProperties, encodingFactory, protocols);
    }

    @Override
    protected String getCnctFile() {
        String expectedDb = ((IServiceProperties)this.attachProperties).getExpectedDb();
        if (expectedDb != null) {
            return expectedDb;
        }
        return super.getCnctFile();
    }

    @Override
    protected DbAttachInfo toDbAttachInfo(IServiceProperties attachProperties) throws SQLException {
        DbAttachInfo dbAttachInfo;
        DbAttachInfo initialDbAttachInfo = DbAttachInfo.of(attachProperties);
        if (initialDbAttachInfo.hasServerName()) {
            dbAttachInfo = initialDbAttachInfo;
        } else if (initialDbAttachInfo.hasAttachObjectName()) {
            dbAttachInfo = DbAttachInfo.parseConnectString(initialDbAttachInfo.getAttachObjectName());
        } else {
            return new DbAttachInfo("localhost", initialDbAttachInfo.getPortNumber(), "service_mgr");
        }
        if (!dbAttachInfo.hasServerName()) {
            dbAttachInfo = dbAttachInfo.withServerName("localhost");
        }
        if (!dbAttachInfo.hasAttachObjectName()) {
            dbAttachInfo = dbAttachInfo.withAttachObjectName("service_mgr");
        }
        return dbAttachInfo;
    }

    @Override
    protected FbWireService createConnectionHandle(ProtocolDescriptor protocolDescriptor) {
        return protocolDescriptor.createService(this);
    }
}

