/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBShortField
extends FBField {
    private static final BigDecimal BD_MAX_SHORT = BigDecimal.valueOf(32767L);
    private static final BigDecimal BD_MIN_SHORT = BigDecimal.valueOf(-32768L);
    private static final BigInteger BI_MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger BI_MIN_SHORT = BigInteger.valueOf(-32768L);

    FBShortField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getInt();
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        short value = this.getDatatypeCoder().decodeShort(this.getFieldData());
        if (value > 127 || value < -128) {
            throw this.invalidGetConversion("byte", String.format("value %d out of range", value));
        }
        return (byte)value;
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.getDatatypeCoder().decodeShort(this.getFieldData());
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.getDatatypeCoder().decodeShort(this.getFieldData());
    }

    @Override
    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.getDatatypeCoder().decodeShort(this.getFieldData());
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.getDatatypeCoder().decodeShort(this.getFieldData());
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.getDatatypeCoder().decodeShort(this.getFieldData());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.getDatatypeCoder().decodeShort(this.getFieldData()));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.getDatatypeCoder().decodeShort(this.getFieldData()) == 1;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getDatatypeCoder().decodeShort(this.getFieldData()));
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigInteger.valueOf(this.getShort());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setShort(Short.parseShort(string));
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidSetConversion(String.class, string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeShort(value));
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setShort((short)(value ? 1 : 0));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        if (value > 32767.0f || value < -32768.0f) {
            throw this.invalidSetConversion("float", String.format("value %f out of range", Float.valueOf(value)));
        }
        this.setShort((short)value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value > 32767.0 || value < -32768.0) {
            throw this.invalidSetConversion("double", String.format("value %f out of range", value));
        }
        this.setShort((short)value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        if (value > 32767L || value < -32768L) {
            throw this.invalidSetConversion("long", String.format("value %d out of range", value));
        }
        this.setShort((short)value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw this.invalidSetConversion("int", String.format("value %d out of range", value));
        }
        this.setShort((short)value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setShort(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BD_MAX_SHORT) > 0 || value.compareTo(BD_MIN_SHORT) < 0) {
            throw this.invalidSetConversion(BigDecimal.class, String.format("value %f out of range", value));
        }
        this.setShort(value.shortValue());
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.compareTo(BI_MAX_SHORT) > 0 || value.compareTo(BI_MIN_SHORT) < 0) {
            throw this.invalidSetConversion(BigInteger.class, String.format("value %d out of range", value));
        }
        this.setShort(value.shortValueExact());
    }
}

