/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSet2ByteFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter2ByteFixed";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final short CHARLENGTH = 2;
    static Class m_charConvSuperclass;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    CharacterSet2ByteFixed(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$3, null, oracleId, charConverter);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static CharacterSet2ByteFixed getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void charConverter;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$0, null, n2, jdbcCharacterConverters);
            }
            if (charConverter.getGroupId() == 6) {
                int oracleId;
                CharacterSet2ByteFixed characterSet2ByteFixed = new CharacterSet2ByteFixed(oracleId, (JdbcCharacterConverters)charConverter);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$0, null, characterSet2ByteFixed);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$0, null, null);
                }
                return characterSet2ByteFixed;
            }
            CharacterSet2ByteFixed characterSet2ByteFixed = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$0, null, characterSet2ByteFixed);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$0, null, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void walker;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$1, this, characterWalker);
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (walker.bytes.length > walker.next) {
                c2 = c2 << 8 | walker.bytes[walker.next];
                ++walker.next;
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = c2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$1, this, n2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$1, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$2, this, characterBuffer, n2);
            }
            CharacterSet2ByteFixed.need((CharacterBuffer)buffer, 2);
            buffer.bytes[buffer.next++] = (byte)(c2 >> 8 & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(c2 & 0xFF);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSet2ByteFixed.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = CharacterSet2ByteFixed.class.getDeclaredConstructor(Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSet2ByteFixed.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSet2ByteFixed.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSet2ByteFixed.class.getDeclaredMethod("getInstance", Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

