/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPOutputStream;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.command.serialize.options.SerializationFormat;
import schemacrawler.tools.command.serialize.options.SerializationOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.property.PropertyName;

public final class SerializationCommand
extends BaseSchemaCrawlerCommand<SerializationOptions> {
    static final PropertyName COMMAND = new PropertyName("serialize", "Create an offline catalog snapshot");

    public SerializationCommand() {
        super(COMMAND);
    }

    public void checkAvailability() {
    }

    public void execute() {
        block10: {
            CatalogSerializer catalogSerializer;
            this.checkCatalog();
            SerializationFormat serializationFormat = SerializationFormat.fromFormat(this.outputOptions.getOutputFormatValue());
            String serializerClassName = serializationFormat.getSerializerClassName();
            try {
                Class<?> serializableCatalogClass = Class.forName(serializerClassName);
                catalogSerializer = (CatalogSerializer)serializableCatalogClass.getDeclaredConstructor(Catalog.class).newInstance(this.catalog);
            }
            catch (Exception e) {
                throw new InternalRuntimeException(String.format("Could not instantiate catalog serializer<%s>", serializerClassName), (Throwable)e);
            }
            if (serializationFormat.isBinaryFormat()) {
                Path outputFile = this.outputOptions.getOutputFile(serializationFormat.getFileExtension());
                this.outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.outputOptions).withOutputFile(outputFile).toOptions();
                try (GZIPOutputStream out = new GZIPOutputStream(Files.newOutputStream(outputFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
                    catalogSerializer.save(out);
                    break block10;
                }
                catch (IOException e) {
                    throw new IORuntimeException("Could not save catalog", e);
                }
            }
            PrintWriter out = this.outputOptions.openNewOutputWriter();
            catalogSerializer.save(out);
        }
    }
}

