/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.crl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import net.snowflake.client.core.Constants;

class CRLValidationConfig {
    private final CertRevocationCheckMode certRevocationCheckMode;
    private final boolean allowCertificatesWithoutCrlUrl;
    private final int connectionTimeoutMs;
    private final int readTimeoutMs;
    private final boolean inMemoryCacheEnabled;
    private final boolean onDiskCacheEnabled;
    private final Duration cacheValidityTime;
    private final Path onDiskCacheDir;
    private final Duration onDiskCacheRemovalDelay;

    private CRLValidationConfig(Builder builder) {
        this.certRevocationCheckMode = builder.certRevocationCheckMode;
        this.allowCertificatesWithoutCrlUrl = builder.allowCertificatesWithoutCrlUrl;
        this.connectionTimeoutMs = builder.connectionTimeoutMs;
        this.readTimeoutMs = builder.readTimeoutMs;
        this.inMemoryCacheEnabled = builder.inMemoryCacheEnabled;
        this.onDiskCacheEnabled = builder.onDiskCacheEnabled;
        this.cacheValidityTime = builder.cacheValidityTime;
        this.onDiskCacheDir = builder.onDiskCacheDir;
        this.onDiskCacheRemovalDelay = builder.onDiskCacheRemovalDelay;
    }

    CertRevocationCheckMode getCertRevocationCheckMode() {
        return this.certRevocationCheckMode;
    }

    boolean isAllowCertificatesWithoutCrlUrl() {
        return this.allowCertificatesWithoutCrlUrl;
    }

    int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    boolean isInMemoryCacheEnabled() {
        return this.inMemoryCacheEnabled;
    }

    boolean isOnDiskCacheEnabled() {
        return this.onDiskCacheEnabled;
    }

    Duration getCacheValidityTime() {
        return this.cacheValidityTime;
    }

    Path getOnDiskCacheDir() {
        return this.onDiskCacheDir;
    }

    Duration getOnDiskCacheRemovalDelay() {
        return this.onDiskCacheRemovalDelay;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private CertRevocationCheckMode certRevocationCheckMode = CertRevocationCheckMode.DISABLED;
        private boolean allowCertificatesWithoutCrlUrl = false;
        private int connectionTimeoutMs = 30000;
        private int readTimeoutMs = 30000;
        private boolean inMemoryCacheEnabled = true;
        private boolean onDiskCacheEnabled = true;
        private Duration cacheValidityTime = Duration.ofDays(1L);
        private Path onDiskCacheDir = Builder.getDefaultCacheDir();
        private Duration onDiskCacheRemovalDelay = Duration.ofDays(7L);

        Builder() {
        }

        Builder certRevocationCheckMode(CertRevocationCheckMode mode) {
            this.certRevocationCheckMode = mode;
            return this;
        }

        Builder allowCertificatesWithoutCrlUrl(boolean allow) {
            this.allowCertificatesWithoutCrlUrl = allow;
            return this;
        }

        Builder connectionTimeoutMs(int timeoutMs) {
            this.connectionTimeoutMs = timeoutMs;
            return this;
        }

        Builder readTimeoutMs(int timeoutMs) {
            this.readTimeoutMs = timeoutMs;
            return this;
        }

        Builder inMemoryCacheEnabled(boolean enabled) {
            this.inMemoryCacheEnabled = enabled;
            return this;
        }

        Builder onDiskCacheEnabled(boolean enabled) {
            this.onDiskCacheEnabled = enabled;
            return this;
        }

        Builder cacheValidityTime(Duration duration) {
            this.cacheValidityTime = duration;
            return this;
        }

        Builder onDiskCacheDir(Path cacheDir) {
            this.onDiskCacheDir = cacheDir;
            return this;
        }

        Builder onDiskCacheRemovalDelay(Duration duration) {
            this.onDiskCacheRemovalDelay = duration;
            return this;
        }

        CRLValidationConfig build() {
            return new CRLValidationConfig(this);
        }

        private static Path getDefaultCacheDir() {
            String userHome = System.getProperty("user.home");
            if (Constants.getOS() == Constants.OS.WINDOWS) {
                return Paths.get(userHome, "AppData", "Local", "Snowflake", "Caches", "crls");
            }
            if (Constants.getOS() == Constants.OS.MAC) {
                return Paths.get(userHome, "Library", "Caches", "Snowflake", "crls");
            }
            return Paths.get(userHome, ".cache", "snowflake", "crls");
        }
    }

    static enum CertRevocationCheckMode {
        DISABLED,
        ENABLED,
        ADVISORY;

    }
}

