/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.util.Map;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GrantConstraints;

@SdkInternalApi
public class GrantConstraintsMarshaller {
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTSUBSET_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextSubset").build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXTEQUALS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContextEquals").build();
    private static final GrantConstraintsMarshaller instance = new GrantConstraintsMarshaller();

    public static GrantConstraintsMarshaller getInstance() {
        return instance;
    }

    public void marshall(GrantConstraints grantConstraints, ProtocolMarshaller protocolMarshaller) {
        if (grantConstraints == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(grantConstraints.getEncryptionContextSubset(), ENCRYPTIONCONTEXTSUBSET_BINDING);
            protocolMarshaller.marshall(grantConstraints.getEncryptionContextEquals(), ENCRYPTIONCONTEXTEQUALS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

