/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.CallOptionsUtil;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.ResponseMetadataHandler;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.Channel;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.ClientInterceptor;
import net.snowflake.client.jdbc.internal.grpc.ForwardingClientCall;
import net.snowflake.client.jdbc.internal.grpc.ForwardingClientCallListener;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.Status;

@InternalApi
class GrpcMetadataHandlerInterceptor
implements ClientInterceptor {
    GrpcMetadataHandlerInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall<ReqT, RespT> call = next.newCall(method, callOptions);
        final ResponseMetadataHandler metadataHandler = CallOptionsUtil.getMetadataHandlerOption(callOptions);
        if (metadataHandler == null) {
            return call;
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                ForwardingClientCallListener.SimpleForwardingClientCallListener forwardingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                        metadataHandler.onHeaders(headers);
                    }

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        metadataHandler.onTrailers(trailers);
                        super.onClose(status, trailers);
                    }
                };
                super.start(forwardingResponseListener, headers);
            }
        };
    }
}

