/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.OracleType;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.jdbc.driver.AbstractShardingPreparedStatement;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class ShardingKeyInfo {
    static ConcurrentHashMap<Integer, KeyTokenInfo> sqlToShardingKeyTokensMap;
    protected static final int DEPTH = 128;
    public static final int GWS_KEY_RESERVED = 255;
    public static final int GWS_KEY_UNUSED = 0;
    public static final int GWS_KEY_RETURN_TUPLE_20_1 = 82;
    public static final int GWS_KEY_APPEND_KEY_TUPLE_20_1 = 125;
    public static final int GWS_KEY_APPEND_VALUE_KEY_20_1 = 93;
    public static final int GWS_KEY_PUSH_BIND_INDEX_20_1 = 73;
    public static final int GWS_KEY_PUSH_PARAMETER_20_1 = 80;
    public static final int GWS_KEY_PUSH_LITERAL_20_1 = 76;
    public static final int GWS_KEY_PUSH_SQL_TYPE_20_1 = 84;
    public static final int GWS_KEY_PUSH_SHORT_20_1 = 83;
    public static final int GWS_KEY_PUSH_EMPTY_KEY_20_1 = 91;
    public static final int GWS_KEY_PUSH_EMPTY_TUPLE_20_1 = 123;
    protected Stack stack;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    ShardingKeyInfo() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$10, null, new Object[0]);
            }
            this.stack = new Stack(128);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    List<List<Object>> evaluateShardingKeys(OracleStatement oracleStatement, byte[] byArray, short s2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void keyRpnTokens;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, oracleStatement, byArray, s2);
            }
            List keyTuple = null;
            int b2 = 0;
            int len = ((void)keyRpnTokens).length;
            int index = 0;
            block14: while (index < len) {
                b2 = keyRpnTokens[index++];
                List tuple = null;
                List key = null;
                int type = 0;
                Object value = null;
                int num = 0;
                byte[] buf = null;
                switch (b2) {
                    case 82: {
                        keyTuple = this.stack.pop(List.class);
                        if (index == len) {
                            List list = keyTuple;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, list);
                                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, null);
                            }
                            return list;
                        }
                        SQLException sQLException = new SQLException("more than expected sharding key information expression");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, sQLException);
                        }
                        throw sQLException;
                    }
                    case 125: {
                        key = this.stack.pop(List.class);
                        tuple = this.stack.pop(List.class);
                        tuple.add(key);
                        this.stack.push(tuple);
                        continue block14;
                    }
                    case 93: {
                        value = this.stack.pop(Object.class);
                        key = this.stack.pop(List.class);
                        key.add(value);
                        this.stack.push(key);
                        continue block14;
                    }
                    case 80: {
                        void statement;
                        type = this.stack.pop(Integer.class);
                        num = this.stack.pop(Integer.class);
                        this.stack.push(((AbstractShardingPreparedStatement)statement).getBindValue(num, type));
                        continue block14;
                    }
                    case 76: {
                        void dbCharSet;
                        type = this.stack.pop(Integer.class);
                        buf = new byte[this.stack.pop(Short.class).shortValue()];
                        System.arraycopy(keyRpnTokens, index, buf, 0, buf.length);
                        index += buf.length;
                        this.stack.push(this.convertDatumToJavaObject(buf, type, (short)dbCharSet));
                        continue block14;
                    }
                    case 84: {
                        num = (short)(((keyRpnTokens[index++] & 0xFF) << 8) + (keyRpnTokens[index++] & 0xFF));
                        this.stack.push(num);
                        continue block14;
                    }
                    case 83: {
                        num = (short)(((keyRpnTokens[index++] & 0xFF) << 8) + (keyRpnTokens[index++] & 0xFF));
                        this.stack.push((short)num);
                        continue block14;
                    }
                    case 73: {
                        num = ((keyRpnTokens[index++] & 0xFF) << 24) + ((keyRpnTokens[index++] & 0xFF) << 16) + ((keyRpnTokens[index++] & 0xFF) << 8) + (keyRpnTokens[index++] & 0xFF);
                        this.stack.push(num);
                        continue block14;
                    }
                    case 91: {
                        this.stack.push(new ArrayList());
                        continue block14;
                    }
                    case 123: {
                        this.stack.push(new ArrayList());
                        continue block14;
                    }
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(1704).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(1704).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Object convertDatumToJavaObject(byte[] byArray, int n2, short s2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            Object subkeyVal;
            void dbCharSet;
            void internalType;
            void buf;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$1, this, byArray, n2, s2);
            }
            Datum subkeyDatum = SQLUtil.makeDatum(null, (byte[])buf, (int)internalType, null, 0, (short)873, (short)dbCharSet);
            Object object = subkeyVal = ShardingKeyInfo.SQLToJavaKeyObject(subkeyDatum, (int)internalType);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$1, this, object);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$1, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    OracleShardingKey[] getShardingKeys(OracleStatement oracleStatement, byte[] byArray, OracleDataSource oracleDataSource, short s2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void ods;
            void dbCharSet;
            void keyRpnTokens;
            void statement;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$2, this, oracleStatement, byArray, oracleDataSource, s2);
            }
            OracleShardingKey[] shardingKeys = new OracleShardingKey[2];
            List<List<Object>> keyTuple = this.evaluateShardingKeys((OracleStatement)statement, (byte[])keyRpnTokens, (short)dbCharSet);
            OracleShardingKeyBuilder shardingKeyBuilder = ods.createShardingKeyBuilder();
            if (keyTuple != null && !keyTuple.isEmpty()) {
                shardingKeyBuilder = this.addSubKeys(shardingKeyBuilder, keyTuple.get(0));
                shardingKeys[0] = shardingKeyBuilder.build();
                if (keyTuple.size() > 1) {
                    OracleShardingKeyBuilder superShardingKeyBuilder = ods.createShardingKeyBuilder();
                    superShardingKeyBuilder = this.addSubKeys(superShardingKeyBuilder, keyTuple.get(1));
                    shardingKeys[1] = superShardingKeyBuilder.build();
                }
            }
            OracleShardingKey[] oracleShardingKeyArray = shardingKeys;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$2, this, oracleShardingKeyArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$2, this, null);
            }
            return shardingKeys;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    OracleShardingKeyBuilder addSubKeys(OracleShardingKeyBuilder oracleShardingKeyBuilder, List<Object> list) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void shardingKeyBuilder;
            void subkeyVals;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$3, this, oracleShardingKeyBuilder, list);
            }
            for (Object subkeyVal : subkeyVals) {
                SQLType subkeyType = this.getKeyType(subkeyVal);
                shardingKeyBuilder.subkey(subkeyVal, subkeyType);
            }
            void var7_7 = shardingKeyBuilder;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$3, this, var7_7);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$3, this, null);
            }
            return var7_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    SQLType getKeyType(Object object) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleType sqltype;
            void val;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$4, this, object);
            }
            int externalType = this.sqlTypeForObject(val);
            OracleType oracleType = sqltype = OracleType.toOracleType(externalType);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$4, this, oracleType);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$4, this, null);
            }
            return oracleType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int sqlTypeForObject(Object object) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, object);
            }
            if (x2 == null) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                }
                return 0;
            }
            if (!(x2 instanceof Datum)) {
                if (x2 instanceof String) {
                    int n3 = 12;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 12;
                }
                if (x2 instanceof BigDecimal) {
                    int n4 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n4);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof BigInteger) {
                    int n5 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof Boolean) {
                    int n6 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n6);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof Integer) {
                    int n7 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n7);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof Long) {
                    int n8 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n8);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof Float) {
                    int n9 = 6;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n9);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 6;
                }
                if (x2 instanceof Double) {
                    int n10 = 8;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n10);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 8;
                }
                if (x2 instanceof byte[]) {
                    int n11 = -2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n11);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return -2;
                }
                if (x2 instanceof Short) {
                    int n12 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n12);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof Byte) {
                    int n13 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n13);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof Date) {
                    int n14 = 91;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n14);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 91;
                }
                if (x2 instanceof Time) {
                    int n15 = 92;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n15);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 92;
                }
                if (x2 instanceof Timestamp) {
                    int n16 = 93;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n16);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 93;
                }
                if (x2 instanceof URL) {
                    int n17 = 12;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n17);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 12;
                }
            } else {
                if (x2 instanceof BINARY_FLOAT) {
                    int n18 = 100;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n18);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 100;
                }
                if (x2 instanceof BINARY_DOUBLE) {
                    int n19 = 101;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n19);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 101;
                }
                if (x2 instanceof NUMBER) {
                    int n20 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n20);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 2;
                }
                if (x2 instanceof DATE) {
                    int n21 = 91;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n21);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 91;
                }
                if (x2 instanceof TIMESTAMP) {
                    int n22 = 93;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n22);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 93;
                }
                if (x2 instanceof CHAR) {
                    int n23 = 1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n23);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return 1;
                }
                if (x2 instanceof RAW) {
                    int n24 = -2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n24);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
                    }
                    return -2;
                }
            }
            int n25 = 1111;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, n25);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, null);
            }
            return 1111;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Object SQLToJavaKeyObject(Datum datum, int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void internalType;
            Datum datum2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$6, null, datum, n2);
            }
            Object ret_obj = null;
            if (datum2 == null) {
                Object var4_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$6, null, var4_4);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$6, null, null);
                }
                return null;
            }
            switch (internalType) {
                case 1: 
                case 96: {
                    ret_obj = datum2.stringValue();
                    break;
                }
                case 2: 
                case 6: {
                    ret_obj = datum2.bigDecimalValue();
                    break;
                }
                case 12: {
                    ret_obj = datum2.dateValue();
                    break;
                }
                case 180: {
                    ret_obj = datum2.timestampValue();
                    break;
                }
                default: {
                    ret_obj = datum2.toJdbc();
                }
            }
            Object object = ret_obj;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$6, null, object);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$6, null, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static KeyTokenInfo putKeyRpnTokens(String string, String string2, String string3, String string4, byte[] byArray, OracleStatement.SqlKind sqlKind) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void schemaName;
            void userName;
            void serviceName;
            String sql;
            void sqlkind;
            void keyRpnTokens;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$7, null, new Object[]{string, string2, string3, string4, byArray, sqlKind});
            }
            KeyTokenInfo keyTokenInfo = new KeyTokenInfo((byte[])keyRpnTokens, (OracleStatement.SqlKind)sqlkind);
            int mapKey = ShardingKeyInfo.calculateTokensHashKey(new String[]{sql, serviceName, userName, schemaName});
            KeyTokenInfo keyTokenInfo2 = sqlToShardingKeyTokensMap.put(mapKey, keyTokenInfo);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$7, null, keyTokenInfo2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$7, null, null);
            }
            return keyTokenInfo2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static KeyTokenInfo getKeyRpnTokens(String string, String string2, String string3, String string4) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void schemaName;
            void userName;
            void serviceName;
            String sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$8, null, string, string2, string3, string4);
            }
            int mapKey = ShardingKeyInfo.calculateTokensHashKey(new String[]{sql, serviceName, userName, schemaName});
            KeyTokenInfo keyTokenInfo = sqlToShardingKeyTokensMap.get(mapKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$8, null, keyTokenInfo);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$8, null, null);
            }
            return keyTokenInfo;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    static int calculateTokensHashKey(String ... stringArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            String[] strKeys;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$9, null, new Object[]{stringArray});
            }
            int tempHashCode = 1;
            for (String key : strKeys) {
                tempHashCode = 31 * tempHashCode + key.hashCode();
            }
            int n2 = tempHashCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$9, null, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$9, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ShardingKeyInfo.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$10 = ShardingKeyInfo.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ShardingKeyInfo.class.getDeclaredMethod("calculateTokensHashKey", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ShardingKeyInfo.class.getDeclaredMethod("getKeyRpnTokens", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ShardingKeyInfo.class.getDeclaredMethod("putKeyRpnTokens", String.class, String.class, String.class, String.class, byte[].class, OracleStatement.SqlKind.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ShardingKeyInfo.class.getDeclaredMethod("SQLToJavaKeyObject", Datum.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ShardingKeyInfo.class.getDeclaredMethod("sqlTypeForObject", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ShardingKeyInfo.class.getDeclaredMethod("getKeyType", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ShardingKeyInfo.class.getDeclaredMethod("addSubKeys", OracleShardingKeyBuilder.class, List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ShardingKeyInfo.class.getDeclaredMethod("getShardingKeys", OracleStatement.class, byte[].class, OracleDataSource.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ShardingKeyInfo.class.getDeclaredMethod("convertDatumToJavaObject", byte[].class, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ShardingKeyInfo.class.getDeclaredMethod("evaluateShardingKeys", OracleStatement.class, byte[].class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        sqlToShardingKeyTokensMap = new ConcurrentHashMap();
    }

    protected static final class KeyTokenInfo {
        private byte[] keyTokens;
        private OracleStatement.SqlKind sqlkind;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public KeyTokenInfo(byte[] keyTokens, OracleStatement.SqlKind sqlkind) {
            this.keyTokens = keyTokens;
            this.sqlkind = sqlkind;
        }

        public byte[] getKeyTokens() {
            return this.keyTokens;
        }

        public OracleStatement.SqlKind getSqlKind() {
            return this.sqlkind;
        }

        static {
            try {
                $$$methodRef$$$2 = KeyTokenInfo.class.getDeclaredConstructor(byte[].class, OracleStatement.SqlKind.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = KeyTokenInfo.class.getDeclaredMethod("getSqlKind", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = KeyTokenInfo.class.getDeclaredMethod("getKeyTokens", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    protected static final class Stack {
        private final Object[] stack;
        private int top = -1;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        public Stack(int depth) {
            this.stack = new Object[depth];
        }

        public boolean isEmpty() {
            return this.top == -1;
        }

        public Stack push(Object value) {
            this.stack[++this.top] = value;
            return this;
        }

        public <T> T pop(Class<T> type) {
            Object v2 = this.stack[this.top];
            this.stack[this.top--] = null;
            return (T)v2;
        }

        static {
            try {
                $$$methodRef$$$3 = Stack.class.getDeclaredConstructor(Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Stack.class.getDeclaredMethod("pop", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Stack.class.getDeclaredMethod("push", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Stack.class.getDeclaredMethod("isEmpty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

