/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.DataTypeRetriever;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.ForeignKeyRetriever;
import schemacrawler.crawl.FunctionParameterRetriever;
import schemacrawler.crawl.IndexRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.PrimaryKeyRetriever;
import schemacrawler.crawl.ProcedureParameterRetriever;
import schemacrawler.crawl.RetrievalTaskRunner;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RoutineExtRetriever;
import schemacrawler.crawl.RoutineRetriever;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.SequenceRetriever;
import schemacrawler.crawl.SynonymRetriever;
import schemacrawler.crawl.TableColumnRetriever;
import schemacrawler.crawl.TableConstraintMatcher;
import schemacrawler.crawl.TableConstraintRetriever;
import schemacrawler.crawl.TableExtRetriever;
import schemacrawler.crawl.TablePrivilegeRetriever;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.crawl.TriggerRetriever;
import schemacrawler.crawl.ViewExtRetriever;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawler {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawler.class.getName());
    private final SchemaCrawlerOptions options;
    private final RetrieverConnection retrieverConnection;
    private final SchemaInfoLevel infoLevel;
    private final int maxThreads;
    private RetrievalTaskRunner taskRunner;
    private MutableCatalog catalog;

    public SchemaCrawler(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions options) {
        try {
            this.retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
            this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
            LoadOptions loadOptions = options.getLoadOptions();
            this.infoLevel = loadOptions.getSchemaInfoLevel();
            this.maxThreads = loadOptions.getMaxThreads();
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(e);
        }
    }

    public Catalog crawl() {
        try {
            try (Connection connection = this.retrieverConnection.getConnection("crawl connection information");){
                ConnectionInfoBuilder connectionInfoBuilder = ConnectionInfoBuilder.builder(connection);
                DatabaseInfo databaseInfo = connectionInfoBuilder.buildDatabaseInfo();
                JdbcDriverInfo jdbcDriverInfo = connectionInfoBuilder.buildJdbcDriverInfo();
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Making a database connection to:%n%s%s", new Object[]{databaseInfo, jdbcDriverInfo}));
                this.catalog = new MutableCatalog("catalog", (MutableDatabaseInfo)databaseInfo, (MutableJdbcDriverInfo)jdbcDriverInfo);
            }
            String runId = this.catalog.getCrawlInfo().getRunId();
            this.taskRunner = new RetrievalTaskRunner(runId, this.infoLevel, this.maxThreads);
            this.crawlDatabaseInfo();
            LOGGER.log(Level.INFO, String.format("%n%s", this.catalog.getCrawlInfo()));
            this.crawlSchemas();
            this.crawlColumnDataTypes();
            this.crawlTables();
            this.crawlRoutines();
            this.crawlSynonyms();
            this.crawlSequences();
            MutableCatalog mutableCatalog = this.catalog;
            return mutableCatalog;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(e);
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException(e);
        }
        finally {
            if (this.taskRunner != null) {
                this.taskRunner.stopAndLogTime();
            }
        }
    }

    private void crawlColumnDataTypes() throws Exception {
        DataTypeRetriever retriever = new DataTypeRetriever(this.retrieverConnection, this.catalog, this.options);
        this.taskRunner.add(SchemaInfoRetrieval.retrieveColumnDataTypes, retriever::retrieveSystemColumnDataTypes, new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveUserDefinedColumnDataTypes, retriever::retrieveUserDefinedColumnDataTypes, new SchemaInfoRetrieval[0]).submit();
    }

    private void crawlDatabaseInfo() throws Exception {
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveDatabaseInfo)) {
            LOGGER.log(Level.INFO, "Not retrieving database information, since this was not requested");
            return;
        }
        DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(this.retrieverConnection, this.catalog, this.options);
        this.taskRunner.add(SchemaInfoRetrieval.retrieveAdditionalDatabaseInfo, retriever::retrieveAdditionalDatabaseInfo, new SchemaInfoRetrieval[0]).add(SchemaInfoRetrieval.retrieveServerInfo, retriever::retrieveServerInfo, new SchemaInfoRetrieval[0]).add(SchemaInfoRetrieval.retrieveDatabaseUsers, retriever::retrieveDatabaseUsers, new SchemaInfoRetrieval[0]).add(SchemaInfoRetrieval.retrieveAdditionalJdbcDriverInfo, retriever::retrieveAdditionalJdbcDriverInfo, new SchemaInfoRetrieval[0]).submit();
    }

    private void crawlRoutines() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveRoutines) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving routines, since this was not requested");
            return;
        }
        RoutineRetriever retriever = new RoutineRetriever(this.retrieverConnection, this.catalog, this.options);
        RoutineExtRetriever retrieverExtra = new RoutineExtRetriever(this.retrieverConnection, this.catalog, this.options);
        ProcedureParameterRetriever procedureParameterRetriever = new ProcedureParameterRetriever(this.retrieverConnection, this.catalog, this.options);
        FunctionParameterRetriever functionParameterRetriever = new FunctionParameterRetriever(this.retrieverConnection, this.catalog, this.options);
        Collection<RoutineType> routineTypes = limitOptions.getRoutineTypes();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveRoutines, () -> retriever.retrieveRoutines(routineTypes, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion)), new SchemaInfoRetrieval[0]).submit();
        NamedObjectList<MutableRoutine> allRoutines = this.catalog.getAllRoutines();
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieved %d routines", new Object[]{allRoutines.size()}));
        if (allRoutines.isEmpty()) {
            return;
        }
        this.taskRunner.add(SchemaInfoRetrieval.retrieveRoutineParameters, () -> {
            LOGGER.log(Level.INFO, "Retrieving routine columns");
            if (!limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion)) {
                if (routineTypes.contains((Object)RoutineType.procedure)) {
                    procedureParameterRetriever.retrieveProcedureParameters(allRoutines, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion));
                }
                if (routineTypes.contains((Object)RoutineType.function)) {
                    functionParameterRetriever.retrieveFunctionParameters(allRoutines, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion));
                }
            }
        }, new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add("filterAndSortRoutines", () -> this.catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer(this.options)), new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveRoutineInformation, retrieverExtra::retrieveRoutineInformation, new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveRoutineReferences, retrieverExtra::retrieveRoutineReferences, new SchemaInfoRetrieval[0]).submit();
    }

    private void crawlSchemas() throws Exception {
        SchemaRetriever retriever = new SchemaRetriever(this.retrieverConnection, this.catalog, this.options);
        this.taskRunner.add("retrieveSchemas", () -> retriever.retrieveSchemas(this.options.getLimitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion)), new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add("filterAndSortSchemas", () -> this.catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer(this.options)), new SchemaInfoRetrieval[0]).submit();
        NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
        if (schemas.isEmpty()) {
            throw new ExecutionRuntimeException("No matching schemas found");
        }
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieved %d schemas", new Object[]{schemas.size()}));
    }

    private void crawlSequences() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveSequenceInformation) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        SequenceRetriever retrieverExtra = new SequenceRetriever(this.retrieverConnection, this.catalog, this.options);
        this.taskRunner.add(SchemaInfoRetrieval.retrieveSequenceInformation, () -> retrieverExtra.retrieveSequenceInformation(limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion)), new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add("filterAndSortSequences", () -> this.catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer(this.options)), new SchemaInfoRetrieval[0]).submit();
    }

    private void crawlSynonyms() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveSynonymInformation) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving synonyms, since this was not requested");
            return;
        }
        SynonymRetriever retrieverExtra = new SynonymRetriever(this.retrieverConnection, this.catalog, this.options);
        this.taskRunner.add(SchemaInfoRetrieval.retrieveSynonymInformation, () -> retrieverExtra.retrieveSynonymInformation(limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion)), new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add("filterAndSortSynonms", () -> this.catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer(this.options)), new SchemaInfoRetrieval[0]).submit();
    }

    private void crawlTables() throws Exception {
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!this.infoLevel.is(SchemaInfoRetrieval.retrieveTables) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForTableInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        TableRetriever retriever = new TableRetriever(this.retrieverConnection, this.catalog, this.options);
        TableColumnRetriever columnRetriever = new TableColumnRetriever(this.retrieverConnection, this.catalog, this.options);
        PrimaryKeyRetriever pkRetriever = new PrimaryKeyRetriever(this.retrieverConnection, this.catalog, this.options);
        ForeignKeyRetriever fkRetriever = new ForeignKeyRetriever(this.retrieverConnection, this.catalog, this.options);
        TableConstraintRetriever constraintRetriever = new TableConstraintRetriever(this.retrieverConnection, this.catalog, this.options);
        TableConstraintMatcher constraintMatcher = new TableConstraintMatcher(this.retrieverConnection, this.catalog, this.options);
        TableExtRetriever retrieverExtra = new TableExtRetriever(this.retrieverConnection, this.catalog, this.options);
        ViewExtRetriever viewExtRetriever = new ViewExtRetriever(this.retrieverConnection, this.catalog, this.options);
        TriggerRetriever triggerRetriever = new TriggerRetriever(this.retrieverConnection, this.catalog, this.options);
        TablePrivilegeRetriever retrieverPrivilege = new TablePrivilegeRetriever(this.retrieverConnection, this.catalog, this.options);
        IndexRetriever indexRetriever = new IndexRetriever(this.retrieverConnection, this.catalog, this.options);
        this.taskRunner.add(SchemaInfoRetrieval.retrieveTables, () -> {
            LOGGER.log(Level.INFO, "Retrieving table names");
            retriever.retrieveTables(limitOptions.getTableNamePattern(), limitOptions.getTableTypes(), limitOptions.get(DatabaseObjectRuleForInclusion.ruleForTableInclusion));
        }, new SchemaInfoRetrieval[0]).submit();
        NamedObjectList<MutableTable> allTables = this.catalog.getAllTables();
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Retrieved %d tables", new Object[]{allTables.size()}));
        if (allTables.isEmpty()) {
            return;
        }
        this.taskRunner.add(SchemaInfoRetrieval.retrieveTableColumns, () -> {
            if (!limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForColumnInclusion)) {
                columnRetriever.retrieveTableColumns(allTables, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForColumnInclusion));
            }
        }, new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrievePrimaryKeys, () -> pkRetriever.retrievePrimaryKeys(allTables), SchemaInfoRetrieval.retrieveTableColumns).add(SchemaInfoRetrieval.retrieveForeignKeys, () -> fkRetriever.retrieveForeignKeys(allTables), SchemaInfoRetrieval.retrieveTableColumns).add(SchemaInfoRetrieval.retrieveIndexes, () -> indexRetriever.retrieveIndexes(allTables), SchemaInfoRetrieval.retrieveTableColumns).add(SchemaInfoRetrieval.retrieveTableConstraints, constraintRetriever::retrieveTableConstraints, SchemaInfoRetrieval.retrieveTableColumns).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveTableConstraintColumns, constraintRetriever::retrieveTableConstraintColumns, SchemaInfoRetrieval.retrieveTableConstraints).add(SchemaInfoRetrieval.retrieveTriggerInformation, triggerRetriever::retrieveTriggerInformation, new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add("filterAndSortTables", () -> {
            this.catalog.reduce(Table.class, ReducerFactory.getTableReducer(this.options));
            TablesGraph tablesGraph = new TablesGraph(allTables);
            tablesGraph.setTablesSortIndexes();
        }, new SchemaInfoRetrieval[0]).submit();
        this.taskRunner.add("matchTableConstraints", () -> constraintMatcher.matchTableConstraints(allTables), SchemaInfoRetrieval.retrieveTableColumns).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveTableConstraintDefinitions, constraintRetriever::retrieveCheckConstraints, SchemaInfoRetrieval.retrieveTableConstraints).add(SchemaInfoRetrieval.retrieveTableConstraintInformation, constraintRetriever::retrieveTableConstraintInformation, SchemaInfoRetrieval.retrieveTableConstraints).add(SchemaInfoRetrieval.retrieveViewInformation, viewExtRetriever::retrieveViewInformation, SchemaInfoRetrieval.retrieveTables).add(SchemaInfoRetrieval.retrieveViewTableUsage, viewExtRetriever::retrieveViewTableUsage, SchemaInfoRetrieval.retrieveTables).add(SchemaInfoRetrieval.retrieveTableDefinitionsInformation, retrieverExtra::retrieveTableDefinitions, SchemaInfoRetrieval.retrieveTables).add(SchemaInfoRetrieval.retrieveIndexInformation, () -> indexRetriever.retrieveIndexInformation(), SchemaInfoRetrieval.retrieveIndexes).add(SchemaInfoRetrieval.retrieveAdditionalTableAttributes, () -> retrieverExtra.retrieveAdditionalTableAttributes(), SchemaInfoRetrieval.retrieveTables).add(SchemaInfoRetrieval.retrieveTablePrivileges, () -> retrieverPrivilege.retrieveTablePrivileges(), SchemaInfoRetrieval.retrieveTables).add(SchemaInfoRetrieval.retrieveTableColumnPrivileges, retrieverPrivilege::retrieveTableColumnPrivileges, SchemaInfoRetrieval.retrieveTableColumns).add(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes, retrieverExtra::retrieveAdditionalColumnAttributes, SchemaInfoRetrieval.retrieveTableColumns).submit();
        this.taskRunner.add(SchemaInfoRetrieval.retrieveAdditionalColumnMetadata, retrieverExtra::retrieveAdditionalColumnMetadata, SchemaInfoRetrieval.retrieveTableColumns).submit();
    }
}

