"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
exports.definitions = [
    {
        zigbeeModel: ["Eco-Dim.05 Zigbee"],
        fingerprint: [
            {
                type: "Router",
                manufacturerName: "EcoDim BV",
                modelID: "EcoDim-Zigbee 3.0",
                endpoints: [
                    { ID: 1, profileID: 260, inputClusters: [0, 3, 4, 5, 6, 8, 2821, 4096], outputClusters: [25] },
                    { ID: 2, profileID: 260, inputClusters: [0, 3, 4, 5, 6, 8], outputClusters: [] },
                    { ID: 242, profileID: 41440, inputClusters: [], outputClusters: [33] },
                ],
            },
            {
                type: "Router",
                manufacturerName: "EcoDim BV",
                modelID: "EcoDim-Zigbee 3.0",
                endpoints: [
                    { ID: 1, profileID: 260, inputClusters: [0, 3, 4, 5, 6, 8, 4096], outputClusters: [25] },
                    { ID: 2, profileID: 260, inputClusters: [0, 3, 4, 5, 6, 8, 4096], outputClusters: [25] },
                    { ID: 242, profileID: 41440, inputClusters: [], outputClusters: [33] },
                ],
            },
        ],
        model: "Eco-Dim.05",
        vendor: "EcoDim",
        description: "LED dimmer duo 2x 0-100W",
        extend: [
            m.deviceEndpoints({ endpoints: { left: 2, right: 1 } }),
            m.light({ effect: false, configureReporting: true, endpointNames: ["left", "right"] }),
        ],
    },
    {
        zigbeeModel: ["eco-dim07-zigbee", "eco-dim07-Pro-zigbee"],
        fingerprint: [
            { type: "Router", manufacturerID: 4714, modelID: "Dimmer-Switch-ZB3.0" },
            {
                type: "Router",
                manufacturerName: "EcoDim BV",
                modelID: "EcoDim-Zigbee 3.0",
                endpoints: [
                    { ID: 1, profileID: 260, deviceID: 257, inputClusters: [0, 3, 4, 5, 6, 8, 2821, 4096], outputClusters: [25] },
                    { ID: 242, profileID: 41440, deviceID: 97, inputClusters: [], outputClusters: [33] },
                ],
            },
            {
                type: "Router",
                manufacturerName: "EcoDim BV",
                modelID: "EcoDim-Zigbee 3.0",
                endpoints: [
                    { ID: 1, profileID: 260, deviceID: 257, inputClusters: [0, 3, 4, 5, 6, 8, 2821, 4096], outputClusters: [25] },
                    { ID: 67, inputClusters: [], outputClusters: [] },
                    { ID: 242, profileID: 41440, deviceID: 97, inputClusters: [], outputClusters: [33] },
                ],
            },
        ],
        model: "Eco-Dim.07/Eco-Dim.10",
        vendor: "EcoDim",
        description: "Zigbee LED dimmer",
        ota: true,
        extend: [m.light({ configureReporting: true })],
    },
    {
        zigbeeModel: ["ED-10010"],
        model: "ED-10010",
        vendor: "EcoDim",
        description: "Zigbee 2 button wall switch - white",
        fromZigbee: [fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        exposes: [e.battery(), e.action(["on", "off", "brightness_move_up", "brightness_move_down", "brightness_stop"])],
        toZigbee: [],
        meta: { multiEndpoint: true },
    },
    {
        zigbeeModel: ["ED-10011"],
        model: "ED-10011",
        vendor: "EcoDim",
        description: "Zigbee 2 button wall switch - black",
        fromZigbee: [fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        exposes: [e.battery(), e.action(["on_1", "off_1", "brightness_move_up_1", "brightness_move_down_1", "brightness_stop_1"])],
        toZigbee: [],
    },
    {
        zigbeeModel: ["ED-10012"],
        model: "ED-10012",
        vendor: "EcoDim",
        description: "Zigbee 4 button wall switch - white",
        fromZigbee: [fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        exposes: [
            e.battery(),
            e.action([
                "on_1",
                "off_1",
                "brightness_move_up_1",
                "brightness_move_down_1",
                "brightness_stop_1",
                "on_2",
                "off_2",
                "brightness_move_up_2",
                "brightness_move_down_2",
                "brightness_stop_2",
            ]),
        ],
        toZigbee: [],
        meta: { multiEndpoint: true, battery: { dontDividePercentage: true } },
    },
    {
        zigbeeModel: ["ED-10013"],
        model: "ED-10013",
        vendor: "EcoDim",
        description: "Zigbee 4 button wall switch - black",
        fromZigbee: [fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        exposes: [
            e.battery(),
            e.action([
                "on_1",
                "off_1",
                "brightness_move_up_1",
                "brightness_move_down_1",
                "brightness_stop_1",
                "on_2",
                "off_2",
                "brightness_move_up_2",
                "brightness_move_down_2",
                "brightness_stop_2",
            ]),
        ],
        toZigbee: [],
        meta: { multiEndpoint: true },
    },
    {
        zigbeeModel: ["ED-10014"],
        model: "ED-10014",
        vendor: "EcoDim",
        description: "Zigbee 8 button wall switch - white",
        fromZigbee: [fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        exposes: [
            e.battery(),
            e.action([
                "on_1",
                "off_1",
                "brightness_move_up_1",
                "brightness_move_down_1",
                "brightness_stop_1",
                "on_2",
                "off_2",
                "brightness_move_up_2",
                "brightness_move_down_2",
                "brightness_stop_2",
                "on_3",
                "off_3",
                "brightness_move_up_3",
                "brightness_move_down_3",
                "brightness_stop_3",
                "on_4",
                "off_4",
                "brightness_move_up_4",
                "brightness_move_down_4",
                "brightness_stop_4",
            ]),
        ],
        toZigbee: [],
        meta: { multiEndpoint: true },
    },
    {
        zigbeeModel: ["ED-10015"],
        model: "ED-10015",
        vendor: "EcoDim",
        description: "Zigbee 8 button wall switch - black",
        fromZigbee: [fz.command_on, fz.command_off, fz.command_move, fz.command_stop, fz.battery],
        exposes: [
            e.battery(),
            e.action([
                "on_1",
                "off_1",
                "brightness_move_up_1",
                "brightness_move_down_1",
                "brightness_stop_1",
                "on_2",
                "off_2",
                "brightness_move_up_2",
                "brightness_move_down_2",
                "brightness_stop_2",
                "on_3",
                "off_3",
                "brightness_move_up_3",
                "brightness_move_down_3",
                "brightness_stop_3",
                "on_4",
                "off_4",
                "brightness_move_up_4",
                "brightness_move_down_4",
                "brightness_stop_4",
            ]),
        ],
        toZigbee: [],
        meta: { multiEndpoint: true },
    },
    {
        fingerprint: tuya.fingerprint("TS0501B", ["_TZ3210_yluvwhjc"]),
        model: "ED-10042",
        vendor: "EcoDim",
        description: "Zigbee LED filament light dimmable E27, globe G125, flame 2200K",
        extend: [tuya.modernExtend.tuyaLight()],
    },
    {
        fingerprint: [
            { modelID: "CCT Light", manufacturerName: "ZigBee/CCT", manufacturerID: 4137 },
            { modelID: "CCT Light", manufacturerName: "Astuta/ZB-CCT", manufacturerID: 4137 },
        ],
        model: "ED-10041",
        vendor: "EcoDim",
        description: "Zigbee LED filament light dimmable E27, edison ST64, flame 2200K",
        extend: [tuya.modernExtend.tuyaLight({ colorTemp: { range: [153, 454] } })],
    },
];
//# sourceMappingURL=ecodim.js.map