#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-B4DMbnL15qyHhE21lZkF7y
key:                  arch-hs-0.12.1-B4DMbnL15qyHhE21lZkF7y
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  eab5f5a23bb80ed29312f55ea7661714
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-B4DMbnL15qyHhE21lZkF7y
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-3fWbMSZyrbJIXl91nyKDLU
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j
    algebraic-graphs-0.7-aeMFB3EuDs3BZC1B8vykx
    arch-web-0.3.2-3Ul6csIBfVR8dlmhgvvcpG base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-LOP5sjciwZZGtwvmGKv7ZW
    conduit-extra-1.3.8-1JMiFOCwvslD8QGjqNo8o8 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-FYVcTPpTQQ0ABHZrXKPYKQ
    http-client-0.7.19-EHZ8YuN7FJhcdM1bWuZGu
    http-client-tls-0.3.6.4-7GHufzv4aig4Ncu6224c0U
    megaparsec-9.7.0-8uORpW7l6sW5AZf9TKEbic
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-3IsgQxAJj4E9kPCC3Lp4ED
    optparse-simple-0.1.1.4-A2jB5GdAuJNKePfsGIbKS8
    polysemy-1.9.2.0-BpRgJcjIwNMHGyobiViFnz
    prettyprinter-1.7.1-CSlGZoOoBlWC7jpjoL7RBV
    prettyprinter-ansi-terminal-1.1.3-Jr4QPQoU3qM4H72wvTz5B6
    servant-client-0.20.3.0-5QnW5lYBZV9lthvjSODbI
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-409BkpvrA9r2Krrl7oq0GG template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

