﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/MalwareProtectionPlanTaggingActionStatus.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Information about adding tags to the scanned S3 object after the scan
   * result.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionPlanTaggingAction">AWS
   * API Reference</a></p>
   */
  class MalwareProtectionPlanTaggingAction
  {
  public:
    AWS_GUARDDUTY_API MalwareProtectionPlanTaggingAction() = default;
    AWS_GUARDDUTY_API MalwareProtectionPlanTaggingAction(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API MalwareProtectionPlanTaggingAction& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Indicates whether or not the tags will added.</p>
     */
    inline MalwareProtectionPlanTaggingActionStatus GetStatus() const { return m_status; }
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
    inline void SetStatus(MalwareProtectionPlanTaggingActionStatus value) { m_statusHasBeenSet = true; m_status = value; }
    inline MalwareProtectionPlanTaggingAction& WithStatus(MalwareProtectionPlanTaggingActionStatus value) { SetStatus(value); return *this;}
    ///@}
  private:

    MalwareProtectionPlanTaggingActionStatus m_status{MalwareProtectionPlanTaggingActionStatus::NOT_SET};
    bool m_statusHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
