/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIEngineFactory;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LazyValue;

public class AIEngineDescriptor
extends AbstractDescriptor {
    private final IConfigurationElement contributorConfig;
    private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private final AbstractDescriptor.ObjectType objectType;
    private final LazyValue<AIEngineFactory<?>, DBException> factoryInstance;

    protected AIEngineDescriptor(IConfigurationElement contributorConfig) {
        super(contributorConfig);
        this.contributorConfig = contributorConfig;
        this.objectType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, contributorConfig, "class");
        this.factoryInstance = new LazyValue<AIEngineFactory<?>, DBException>(){

            @NotNull
            protected AIEngineFactory<?> initialize() throws DBException {
                return (AIEngineFactory)AIEngineDescriptor.this.objectType.createInstance(AIEngineFactory.class, new Object[]{AISettingsRegistry.getInstance()});
            }
        };
        for (IConfigurationElement propGroup : ArrayUtils.safeArray((Object[])contributorConfig.getChildren("propertyGroup"))) {
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)propGroup));
        }
    }

    public String getId() {
        return this.contributorConfig.getAttribute("id");
    }

    public String getLabel() {
        return this.contributorConfig.getAttribute("label");
    }

    public String getReplaces() {
        return this.contributorConfig.getAttribute("replaces");
    }

    public boolean isDefault() {
        return CommonUtils.toBoolean((Object)this.contributorConfig.getAttribute("default"));
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public AIEngine createInstance() throws DBException {
        return ((AIEngineFactory)this.factoryInstance.getInstance()).getEngine();
    }
}

