/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.oauth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import java.awt.Desktop;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.oauth.OAuthRequestURLBuilder;
import org.jkiss.utils.oauth.OAuthResponseHandler;

public class OAuthHandler {
    protected static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().create();
    public static final int TOKEN_VERIFIER_BYTE_LENGTH = 64;
    @NotNull
    protected final String clientId;
    @Nullable
    protected final String secretId;
    @NotNull
    protected final String authUrl;
    @NotNull
    protected final String tokenURL;
    protected final int callbackPort;
    protected int timeout = 120;
    @NotNull
    protected String callbackEndpoint = "/callback";
    @Nullable
    protected String codeChallenge;

    public OAuthHandler(@NotNull String clientId, @Nullable String secretId, @NotNull String authUrl, @NotNull String tokenURL, int callbackPort) {
        this.clientId = clientId;
        this.secretId = secretId;
        this.authUrl = authUrl;
        this.tokenURL = tokenURL;
        this.callbackPort = callbackPort;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setCallbackEndpoint(@NotNull String callbackEndpoint) {
        this.callbackEndpoint = callbackEndpoint;
    }

    public Map<String, String> authorize() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (OAuthResponseHandler handler = new OAuthResponseHandler(this.callbackPort, this.callbackEndpoint);){
                String verifier = this.generateCodeChallengeAndVerifier();
                this.startSSO(handler);
                String code = handler.requestCode().get(this.timeout, TimeUnit.SECONDS);
                HttpRequest.Builder postBuilder = HttpRequest.newBuilder().uri(URI.create(this.tokenURL));
                postBuilder.header("Content-type", "application/x-www-form-urlencoded");
                postBuilder.POST(HttpRequest.BodyPublishers.ofString(this.createTokenRequestParameters(code, verifier)));
                postBuilder.timeout(Duration.ofSeconds(this.timeout));
                HttpRequest postRequest = postBuilder.build();
                handler.addStabContext();
                HttpClient client = HttpClient.newBuilder().cookieHandler(new CookieManager()).version(HttpClient.Version.HTTP_2).build();
                HttpResponse<String> response = client.send(postRequest, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    throw new IOException("Error getting token info " + response.body());
                }
                return this.extractResponse(response);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    protected Map<String, String> extractResponse(HttpResponse<String> response) throws IOException {
        JsonObject jsonObject = JsonParser.parseString((String)response.body()).getAsJsonObject();
        String idToken = jsonObject.get("id_token").getAsString();
        if (idToken != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("token", idToken);
            return result;
        }
        throw new IOException("Error extracting token");
    }

    private void startSSO(@NotNull OAuthResponseHandler handler) throws IOException {
        handler.initServer();
        this.createBrowser(this.buildAuthUrl());
    }

    protected void createBrowser(@NotNull String url) throws IOException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            throw new IOException("Desktop BROWSER interface is not supported");
        }
        Desktop.getDesktop().browse(URI.create(url));
    }

    @NotNull
    private String generateCodeChallengeAndVerifier() throws IOException {
        String codeVerifier = OAuthHandler.generateVerifier();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] shaEncode = digest.digest(codeVerifier.getBytes());
            this.codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(shaEncode);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Missing SHA-256 algorithm");
        }
        return codeVerifier;
    }

    @NotNull
    private static String generateVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] secureValue = new byte[64];
        secureRandom.nextBytes(secureValue);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(secureValue);
    }

    @NotNull
    private String createTokenRequestParameters(@NotNull String code, @NotNull String verifier) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "authorization_code");
        parameters.put("code", code);
        parameters.put("client_id", this.clientId);
        if (CommonUtils.isNotEmpty(this.secretId)) {
            parameters.put("client_secret", this.secretId);
        }
        parameters.put("code_verifier", verifier);
        parameters.put("redirect_uri", String.format("http://localhost:%s%s", this.callbackPort, this.callbackEndpoint));
        return OAuthRequestURLBuilder.buildURLParameters(parameters);
    }

    protected String buildAuthUrl() throws IOException {
        return new OAuthRequestURLBuilder(this.authUrl).withClientId(this.clientId).withRedirectURI(String.format("http://localhost:%s%s", this.callbackPort, this.callbackEndpoint)).withCodeChallenge(this.codeChallenge).build();
    }
}

