/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.TypePattern;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class Pattern
extends Expression {
    boolean isTotalTypeNode = false;
    private Pattern enclosingPattern;
    protected MethodBinding accessorMethod;
    BranchLabel elseTarget;
    BranchLabel thenTarget;
    public int index = -1;

    @Override
    public boolean containsPatternVariable() {
        class PatternVariablesVisitor
        extends ASTVisitor {
            public boolean hasPatternVar = false;
            public boolean typeElidedVar = false;

            PatternVariablesVisitor() {
            }

            @Override
            public boolean visit(TypePattern typePattern, BlockScope blockScope) {
                this.hasPatternVar = typePattern.local != null;
                this.typeElidedVar |= typePattern.getType() == null || typePattern.getType().isTypeNameVar(blockScope);
                return !this.hasPatternVar || !this.typeElidedVar;
            }
        }
        PatternVariablesVisitor pvv = new PatternVariablesVisitor();
        this.traverse((ASTVisitor)pvv, (BlockScope)null);
        return pvv.hasPatternVar;
    }

    public Pattern getEnclosingPattern() {
        return this.enclosingPattern;
    }

    public void setEnclosingPattern(RecordPattern enclosingPattern) {
        this.enclosingPattern = enclosingPattern;
    }

    public boolean coversType(TypeBinding type) {
        return false;
    }

    public boolean isAlwaysTrue() {
        return true;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        this.setTargets(codeStream);
        this.generateOptimizedBoolean(currentScope, codeStream, this.thenTarget, this.elseTarget);
    }

    void setTargets(CodeStream codeStream) {
        if (this.elseTarget == null) {
            this.elseTarget = new BranchLabel(codeStream);
        }
        if (this.thenTarget == null) {
            this.thenTarget = new BranchLabel(codeStream);
        }
    }

    public void suspendVariables(CodeStream codeStream, BlockScope scope) {
    }

    public void resumeVariables(CodeStream codeStream, BlockScope scope) {
    }

    public abstract void generateOptimizedBoolean(BlockScope var1, CodeStream var2, BranchLabel var3, BranchLabel var4);

    public TypeReference getType() {
        return null;
    }

    protected abstract boolean isPatternTypeCompatible(TypeBinding var1, BlockScope var2);

    public abstract boolean dominates(Pattern var1);

    @Override
    public StringBuilder print(int indent, StringBuilder output) {
        return this.printExpression(indent, output);
    }
}

