/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.PendingValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StyleDeclaration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int INITIAL_LENGTH = 8;
    protected Value[] values = new Value[8];
    protected int[] indexes = new int[8];
    protected boolean[] priorities = new boolean[8];
    protected int count;
    private Map<String, LexicalUnit> customProperties = null;

    public int size() {
        return this.count;
    }

    public Value getValue(int n) {
        return this.values[n];
    }

    public int getIndex(int n) {
        return this.indexes[n];
    }

    public boolean getPriority(int n) {
        return this.priorities[n];
    }

    public void remove(int n) {
        --this.count;
        int n2 = n + 1;
        int n3 = n;
        int n4 = this.count - n;
        System.arraycopy(this.values, n2, this.values, n3, n4);
        System.arraycopy(this.indexes, n2, this.indexes, n3, n4);
        System.arraycopy(this.priorities, n2, this.priorities, n3, n4);
        this.values[this.count] = null;
        this.indexes[this.count] = 0;
        this.priorities[this.count] = false;
    }

    public void put(int n, Value value, int n2, boolean bl) {
        this.values[n] = value;
        this.indexes[n] = n2;
        this.priorities[n] = bl;
    }

    public void append(Value value, int n, boolean bl) {
        if (this.values.length == this.count) {
            Value[] valueArray = new Value[this.count * 2];
            int[] nArray = new int[this.count * 2];
            boolean[] blArray = new boolean[this.count * 2];
            System.arraycopy(this.values, 0, valueArray, 0, this.count);
            System.arraycopy(this.indexes, 0, nArray, 0, this.count);
            System.arraycopy(this.priorities, 0, blArray, 0, this.count);
            this.values = valueArray;
            this.indexes = nArray;
            this.priorities = blArray;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.indexes[i] != n) continue;
            if (bl || this.priorities[i] == bl) {
                this.values[i] = value;
                this.priorities[i] = bl;
            }
            return;
        }
        this.values[this.count] = value;
        this.indexes[this.count] = n;
        this.priorities[this.count] = bl;
        ++this.count;
    }

    public void setCustomProperty(String string, LexicalUnit lexicalUnit, boolean bl) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, LexicalUnit>();
        }
        this.customProperties.put(string, lexicalUnit);
    }

    public Map<String, LexicalUnit> getCustomProperties() {
        return this.customProperties;
    }

    public String toString(CSSEngine cSSEngine) {
        HashSet<String> hashSet = null;
        StringBuilder stringBuilder = new StringBuilder(this.count * 8 + 32);
        for (int i = 0; i < this.count; ++i) {
            PendingValue pendingValue;
            String string;
            Value object = this.values[i];
            if (object.getPrimitiveType() != CSSValue.Type.INTERNAL) {
                stringBuilder.append(cSSEngine.getPropertyName(this.indexes[i]));
                stringBuilder.append(": ");
                stringBuilder.append(object);
                stringBuilder.append(";\n");
                continue;
            }
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            if (!hashSet.add(string = (pendingValue = (PendingValue)object).getShorthandName())) continue;
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(pendingValue.getLexicalUnit().toString());
            stringBuilder.append(";\n");
        }
        if (this.customProperties != null) {
            for (Map.Entry<String, LexicalUnit> entry : this.customProperties.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(": ");
                stringBuilder.append(entry.getValue().toString());
                stringBuilder.append(";\n");
            }
        }
        return stringBuilder.toString();
    }
}

