#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-5nPM6areWSKJozY5QTrQE
key:                  lsp-2.1.0.0-5nPM6areWSKJozY5QTrQE
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  2b454c37ec089dbac760b67c8e517911
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-4BhwIVcG1LCePiTj9eZi9:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-4BhwIVcG1LCePiTj9eZi9:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-4BhwIVcG1LCePiTj9eZi9:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-4BhwIVcG1LCePiTj9eZi9:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-5nPM6areWSKJozY5QTrQE
depends:
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j
    async-2.2.5-DLLO0Mnvxu7HErYx4gsRCE
    attoparsec-0.14.4-FNzLUtPfSaOE1atMnsd5YT base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-IVc4JLhleBcKoxv5Dw511h
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.6.0-JiQr1Tltq7G4W5bcwnoSMj
    lens-5.3.2-5iQf9T9ZD7E1oav0YIbKON
    lsp-types-2.0.1.0-4BhwIVcG1LCePiTj9eZi9 mtl-2.2.2
    prettyprinter-1.7.1-CSlGZoOoBlWC7jpjoL7RBV
    random-1.2.1.3-U9X4N4HDf8JDMoZsBnozN
    row-types-1.0.1.2-D1KlpGrnNKv79rdS0OmUHV
    sorted-list-0.2.3.1-Lj3ozmsMDz5F5dL7uQErG stm-2.5.1.0
    temporary-1.3-9g1OGPiytt1BO3oUGnOgqn text-2.0.2
    text-rope-0.3-6HLnmNF6MujFjExALSWENo transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-C5ENqrDu1w64CLikkGEoYH
    uuid-1.3.16-2nGoE6xvKhhKHUUvbJu5ST

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

