/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Replace the label Ids of selected LabelObjects with new label Ids.


This filter takes as input a label map and a list of pairs of Label Ids, to produce as output a new label map where the label Ids have
been replaced according to the pairs in the list.

Labels that are relabeled to the same label Id are automatically
merged and optimized into a single LabelObject . The background label can also be changed. Any object relabeled to
the output background will automatically be removed.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter , ChangeLabelImageFilter

 itk::simple::ChangeLabelLabelMapFilter for the procedural interface

 itk::ChangeLabelLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkChangeLabelLabelMapFilter.h
*/
public class ChangeLabelLabelMapFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ChangeLabelLabelMapFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ChangeLabelLabelMapFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ChangeLabelLabelMapFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ChangeLabelLabelMapFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ChangeLabelLabelMapFilter::~ChangeLabelLabelMapFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ChangeLabelLabelMapFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ChangeLabelLabelMapFilter::ChangeLabelLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ChangeLabelLabelMapFilter() {
    this(SimpleITKJNI.new_ChangeLabelLabelMapFilter(), true);
  }

  /**
Self&amp; itk::simple::ChangeLabelLabelMapFilter::SetChangeMap(std::map&lt; double, double &gt; ChangeMap)
*/
public  void setChangeMap(DoubleDoubleMap ChangeMap) {
    SimpleITKJNI.ChangeLabelLabelMapFilter_setChangeMap(swigCPtr, this, DoubleDoubleMap.getCPtr(ChangeMap), ChangeMap);
  }

  /**
std::map&lt;double,double&gt; itk::simple::ChangeLabelLabelMapFilter::GetChangeMap() const
*/
public  DoubleDoubleMap getChangeMap() {
    return new DoubleDoubleMap(SimpleITKJNI.ChangeLabelLabelMapFilter_getChangeMap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::ChangeLabelLabelMapFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ChangeLabelLabelMapFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ChangeLabelLabelMapFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ChangeLabelLabelMapFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ChangeLabelLabelMapFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ChangeLabelLabelMapFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
