/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.InternalTopicProperties;

public abstract class BaseRepartitionNode<K, V>
extends GraphNode {
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final String sinkName;
    protected final String sourceName;
    protected final String repartitionTopic;
    protected final StreamPartitioner<K, V> partitioner;
    protected final InternalTopicProperties internalTopicProperties;
    protected ProcessorParameters<K, V, K, V> processorParameters;

    BaseRepartitionNode(String nodeName, String sourceName, ProcessorParameters<K, V, K, V> processorParameters, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic, StreamPartitioner<K, V> partitioner, InternalTopicProperties internalTopicProperties) {
        super(nodeName);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.repartitionTopic = repartitionTopic;
        this.processorParameters = processorParameters;
        this.partitioner = partitioner;
        this.internalTopicProperties = internalTopicProperties;
    }

    Serializer<V> valueSerializer() {
        return this.valueSerde != null ? this.valueSerde.serializer() : null;
    }

    Deserializer<V> valueDeserializer() {
        return this.valueSerde != null ? this.valueSerde.deserializer() : null;
    }

    Serializer<K> keySerializer() {
        return this.keySerde != null ? this.keySerde.serializer() : null;
    }

    Deserializer<K> keyDeserializer() {
        return this.keySerde != null ? this.keySerde.deserializer() : null;
    }

    public void setProcessorParameters(ProcessorParameters<K, V, K, V> processorParameters) {
        this.processorParameters = processorParameters;
    }

    public ProcessorParameters<K, V, K, V> processorParameters() {
        return this.processorParameters;
    }

    @Override
    public String toString() {
        return "BaseRepartitionNode{keySerde=" + String.valueOf(this.keySerde) + ", valueSerde=" + String.valueOf(this.valueSerde) + ", sinkName='" + this.sinkName + "', sourceName='" + this.sourceName + "', repartitionTopic='" + this.repartitionTopic + "', processorParameters=" + String.valueOf(this.processorParameters) + "', partitioner=" + String.valueOf(this.partitioner) + ", internalTopicProperties=" + String.valueOf(this.internalTopicProperties) + "} " + super.toString();
    }

    public static abstract class BaseRepartitionNodeBuilder<K, V, RepartitionNode extends BaseRepartitionNode<K, V>> {
        protected String nodeName;
        protected ProcessorParameters<K, V, K, V> processorParameters;
        protected Serde<K> keySerde;
        protected Serde<V> valueSerde;
        protected String sinkName;
        protected String sourceName;
        protected String repartitionTopic;
        protected StreamPartitioner<K, V> partitioner;
        protected InternalTopicProperties internalTopicProperties = InternalTopicProperties.empty();

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withProcessorParameters(ProcessorParameters<K, V, K, V> processorParameters) {
            this.processorParameters = processorParameters;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withKeySerde(Serde<K> keySerde) {
            this.keySerde = keySerde;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withValueSerde(Serde<V> valueSerde) {
            this.valueSerde = valueSerde;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withSinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withRepartitionTopic(String repartitionTopic) {
            this.repartitionTopic = repartitionTopic;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withStreamPartitioner(StreamPartitioner<K, V> partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public BaseRepartitionNodeBuilder<K, V, RepartitionNode> withInternalTopicProperties(InternalTopicProperties internalTopicProperties) {
            this.internalTopicProperties = internalTopicProperties;
            return this;
        }

        public abstract RepartitionNode build();
    }
}

