/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.stream.Collectors;

public class MultiCollectors {
    public static Uni<String> concatenateStrings(Multi<String> multi) {
        return multi.collect().with(Collectors.joining());
    }

    public static Uni<byte[]> concatenateByteArrays(Multi<byte[]> multi) {
        return multi.collect().asList().map(list -> {
            int size = 0;
            for (byte[] array : list) {
                size += array.length;
            }
            byte[] ret = new byte[size];
            int i = 0;
            for (byte[] array : list) {
                System.arraycopy(array, 0, ret, i, array.length);
                i += array.length;
            }
            return ret;
        });
    }

    public static Uni<char[]> concatenateCharArrays(Multi<char[]> multi) {
        return multi.collect().asList().map(list -> {
            int size = 0;
            for (char[] array : list) {
                size += array.length;
            }
            char[] ret = new char[size];
            int i = 0;
            for (char[] array : list) {
                System.arraycopy(array, 0, ret, i, array.length);
                i += array.length;
            }
            return ret;
        });
    }
}

