/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.common.Nullable;
import org.opensearch.common.hash.MessageDigests;
import org.opensearch.core.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class FingerprintProcessor
extends AbstractProcessor {
    public static final String TYPE = "fingerprint";
    private static final Set<String> HASH_METHODS = Set.of("MD5@2.16.0", "SHA-1@2.16.0", "SHA-256@2.16.0", "SHA3-256@2.16.0");
    private final List<String> fields;
    private final List<String> excludeFields;
    private final String targetField;
    private final String hashMethod;
    private final boolean ignoreMissing;

    FingerprintProcessor(String tag, String description, @Nullable List<String> fields, @Nullable List<String> excludeFields, String targetField, String hashMethod, boolean ignoreMissing) {
        super(tag, description);
        if (fields != null && !fields.isEmpty()) {
            if (fields.stream().anyMatch(Strings::isNullOrEmpty)) {
                throw new IllegalArgumentException("field name in [fields] cannot be null nor empty");
            }
            if (excludeFields != null && !excludeFields.isEmpty()) {
                throw new IllegalArgumentException("either fields or exclude_fields can be set");
            }
        }
        if (excludeFields != null && !excludeFields.isEmpty() && excludeFields.stream().anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("field name in [exclude_fields] cannot be null nor empty");
        }
        if (!HASH_METHODS.contains(hashMethod.toUpperCase(Locale.ROOT))) {
            throw new IllegalArgumentException("hash method must be MD5@2.16.0, SHA-1@2.16.0 or SHA-256@2.16.0 or SHA3-256@2.16.0");
        }
        this.fields = fields;
        this.excludeFields = excludeFields;
        this.targetField = targetField;
        this.hashMethod = hashMethod;
        this.ignoreMissing = ignoreMissing;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public String getHashMethod() {
        return this.hashMethod;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument document) {
        HashSet existingFields = new HashSet(document.getSourceAndMetadata().keySet());
        Set metadataFields = document.getMetadata().keySet().stream().map(IngestDocument.Metadata::getFieldName).collect(Collectors.toSet());
        List<Object> sortedFields = this.fields != null && !this.fields.isEmpty() ? this.fields.stream().distinct().filter(field -> !metadataFields.contains(field)).sorted().collect(Collectors.toList()) : (this.excludeFields != null && !this.excludeFields.isEmpty() ? existingFields.stream().filter(field -> !metadataFields.contains(field) && !this.excludeFields.contains(field)).sorted().collect(Collectors.toList()) : existingFields.stream().filter(field -> !metadataFields.contains(field)).sorted().collect(Collectors.toList()));
        assert (!sortedFields.isEmpty());
        StringBuilder concatenatedFields = new StringBuilder();
        sortedFields.forEach(field -> {
            if (!document.hasField(field)) {
                if (this.ignoreMissing) {
                    return;
                }
                throw new IllegalArgumentException("field [" + field + "] doesn't exist");
            }
            Object value = document.getFieldValue(field, Object.class);
            if (value instanceof Map) {
                Map<String, Object> flattenedMap = this.toFlattenedMap((Map)value);
                flattenedMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    String fieldValue = String.valueOf(entry.getValue());
                    concatenatedFields.append("|").append((String)field).append(".").append((String)entry.getKey()).append("|").append(fieldValue.length()).append(":").append(fieldValue);
                });
            } else {
                String fieldValue = String.valueOf(value);
                concatenatedFields.append("|").append((String)field).append("|").append(fieldValue.length()).append(":").append(fieldValue);
            }
        });
        if (concatenatedFields.length() == 0) {
            return document;
        }
        concatenatedFields.append("|");
        MessageDigest messageDigest = HashMethod.fromMethodName(this.hashMethod);
        assert (messageDigest != null);
        messageDigest.update(concatenatedFields.toString().getBytes(StandardCharsets.UTF_8));
        document.setFieldValue(this.targetField, (Object)(this.hashMethod + ":" + Base64.getEncoder().encodeToString(messageDigest.digest())));
        return document;
    }

    public String getType() {
        return TYPE;
    }

    private Map<String, Object> toFlattenedMap(Map<String, Object> map) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.toFlattenedMap((Map)entry.getValue()).forEach((key, value) -> flattenedMap.put((String)entry.getKey() + "." + key, value));
                continue;
            }
            flattenedMap.put(entry.getKey(), entry.getValue());
        }
        return flattenedMap;
    }

    static enum HashMethod {
        MD5(MessageDigests.md5()),
        SHA1(MessageDigests.sha1()),
        SHA256(MessageDigests.sha256()),
        SHA3256(MessageDigests.sha3256());

        private final MessageDigest messageDigest;

        private HashMethod(MessageDigest messageDigest) {
            this.messageDigest = messageDigest;
        }

        public static MessageDigest fromMethodName(String methodName) {
            String name;
            switch (name = methodName.toUpperCase(Locale.ROOT)) {
                case "MD5@2.16.0": {
                    return HashMethod.MD5.messageDigest;
                }
                case "SHA-1@2.16.0": {
                    return HashMethod.SHA1.messageDigest;
                }
                case "SHA-256@2.16.0": {
                    return HashMethod.SHA256.messageDigest;
                }
                case "SHA3-256@2.16.0": {
                    return HashMethod.SHA3256.messageDigest;
                }
            }
            return null;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        public FingerprintProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            List fields = ConfigurationUtils.readOptionalList((String)FingerprintProcessor.TYPE, (String)processorTag, config, (String)"fields");
            List excludeFields = ConfigurationUtils.readOptionalList((String)FingerprintProcessor.TYPE, (String)processorTag, config, (String)"exclude_fields");
            if (fields != null && !fields.isEmpty()) {
                if (fields.stream().anyMatch(Strings::isNullOrEmpty)) {
                    throw ConfigurationUtils.newConfigurationException((String)FingerprintProcessor.TYPE, (String)processorTag, (String)"fields", (String)"field name cannot be null nor empty");
                }
                if (excludeFields != null && !excludeFields.isEmpty()) {
                    throw ConfigurationUtils.newConfigurationException((String)FingerprintProcessor.TYPE, (String)processorTag, (String)"fields", (String)"either fields or exclude_fields can be set");
                }
            }
            if (excludeFields != null && !excludeFields.isEmpty() && excludeFields.stream().anyMatch(Strings::isNullOrEmpty)) {
                throw ConfigurationUtils.newConfigurationException((String)FingerprintProcessor.TYPE, (String)processorTag, (String)"exclude_fields", (String)"field name cannot be null nor empty");
            }
            String targetField = ConfigurationUtils.readStringProperty((String)FingerprintProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)FingerprintProcessor.TYPE);
            String hashMethod = ConfigurationUtils.readStringProperty((String)FingerprintProcessor.TYPE, (String)processorTag, config, (String)"hash_method", (String)"SHA-1@2.16.0");
            if (!HASH_METHODS.contains(hashMethod.toUpperCase(Locale.ROOT))) {
                throw ConfigurationUtils.newConfigurationException((String)FingerprintProcessor.TYPE, (String)processorTag, (String)"hash_method", (String)"hash method must be MD5@2.16.0, SHA-1@2.16.0, SHA-256@2.16.0 or SHA3-256@2.16.0");
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)FingerprintProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new FingerprintProcessor(processorTag, description, fields, excludeFields, targetField, hashMethod, ignoreMissing);
        }
    }
}

