/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.EbsStatusSummary;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEvent;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEventListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceStatusSummary;
import software.amazon.awssdk.services.ec2.model.OperatorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStatus> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(InstanceStatus.getter(InstanceStatus::availabilityZone)).setter(InstanceStatus.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(InstanceStatus.getter(InstanceStatus::outpostArn)).setter(InstanceStatus.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(InstanceStatus.getter(InstanceStatus::operator)).setter(InstanceStatus.setter(Builder::operator)).constructor(OperatorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("operator").build()}).build();
    private static final SdkField<List<InstanceStatusEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(InstanceStatus.getter(InstanceStatus::events)).setter(InstanceStatus.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsSet").unmarshallLocationName("eventsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceStatusEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceStatus.getter(InstanceStatus::instanceId)).setter(InstanceStatus.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<InstanceState> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceState").getter(InstanceStatus.getter(InstanceStatus::instanceState)).setter(InstanceStatus.setter(Builder::instanceState)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState").unmarshallLocationName("instanceState").build()}).build();
    private static final SdkField<InstanceStatusSummary> INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceStatus").getter(InstanceStatus.getter(InstanceStatus::instanceStatus)).setter(InstanceStatus.setter(Builder::instanceStatus)).constructor(InstanceStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").unmarshallLocationName("instanceStatus").build()}).build();
    private static final SdkField<InstanceStatusSummary> SYSTEM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SystemStatus").getter(InstanceStatus.getter(InstanceStatus::systemStatus)).setter(InstanceStatus.setter(Builder::systemStatus)).constructor(InstanceStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemStatus").unmarshallLocationName("systemStatus").build()}).build();
    private static final SdkField<EbsStatusSummary> ATTACHED_EBS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachedEbsStatus").getter(InstanceStatus.getter(InstanceStatus::attachedEbsStatus)).setter(InstanceStatus.setter(Builder::attachedEbsStatus)).constructor(EbsStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedEbsStatus").unmarshallLocationName("attachedEbsStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, OUTPOST_ARN_FIELD, OPERATOR_FIELD, EVENTS_FIELD, INSTANCE_ID_FIELD, INSTANCE_STATE_FIELD, INSTANCE_STATUS_FIELD, SYSTEM_STATUS_FIELD, ATTACHED_EBS_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String outpostArn;
    private final OperatorResponse operator;
    private final List<InstanceStatusEvent> events;
    private final String instanceId;
    private final InstanceState instanceState;
    private final InstanceStatusSummary instanceStatus;
    private final InstanceStatusSummary systemStatus;
    private final EbsStatusSummary attachedEbsStatus;

    private InstanceStatus(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.outpostArn = builder.outpostArn;
        this.operator = builder.operator;
        this.events = builder.events;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
        this.instanceStatus = builder.instanceStatus;
        this.systemStatus = builder.systemStatus;
        this.attachedEbsStatus = builder.attachedEbsStatus;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final OperatorResponse operator() {
        return this.operator;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<InstanceStatusEvent> events() {
        return this.events;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceState instanceState() {
        return this.instanceState;
    }

    public final InstanceStatusSummary instanceStatus() {
        return this.instanceStatus;
    }

    public final InstanceStatusSummary systemStatus() {
        return this.systemStatus;
    }

    public final EbsStatusSummary attachedEbsStatus() {
        return this.attachedEbsStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedEbsStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.operator(), other.operator()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceState(), other.instanceState()) && Objects.equals(this.instanceStatus(), other.instanceStatus()) && Objects.equals(this.systemStatus(), other.systemStatus()) && Objects.equals(this.attachedEbsStatus(), other.attachedEbsStatus());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceStatus").add("AvailabilityZone", (Object)this.availabilityZone()).add("OutpostArn", (Object)this.outpostArn()).add("Operator", (Object)this.operator()).add("Events", this.hasEvents() ? this.events() : null).add("InstanceId", (Object)this.instanceId()).add("InstanceState", (Object)this.instanceState()).add("InstanceStatus", (Object)this.instanceStatus()).add("SystemStatus", (Object)this.systemStatus()).add("AttachedEbsStatus", (Object)this.attachedEbsStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceState()));
            }
            case "InstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.instanceStatus()));
            }
            case "SystemStatus": {
                return Optional.ofNullable(clazz.cast(this.systemStatus()));
            }
            case "AttachedEbsStatus": {
                return Optional.ofNullable(clazz.cast(this.attachedEbsStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("EventsSet", EVENTS_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceState", INSTANCE_STATE_FIELD);
        map.put("InstanceStatus", INSTANCE_STATUS_FIELD);
        map.put("SystemStatus", SYSTEM_STATUS_FIELD);
        map.put("AttachedEbsStatus", ATTACHED_EBS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatus, T> g) {
        return obj -> g.apply((InstanceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String outpostArn;
        private OperatorResponse operator;
        private List<InstanceStatusEvent> events = DefaultSdkAutoConstructList.getInstance();
        private String instanceId;
        private InstanceState instanceState;
        private InstanceStatusSummary instanceStatus;
        private InstanceStatusSummary systemStatus;
        private EbsStatusSummary attachedEbsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            this.availabilityZone(model.availabilityZone);
            this.outpostArn(model.outpostArn);
            this.operator(model.operator);
            this.events(model.events);
            this.instanceId(model.instanceId);
            this.instanceState(model.instanceState);
            this.instanceStatus(model.instanceStatus);
            this.systemStatus(model.systemStatus);
            this.attachedEbsStatus(model.attachedEbsStatus);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final List<InstanceStatusEvent.Builder> getEvents() {
            List<InstanceStatusEvent.Builder> result = InstanceStatusEventListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<InstanceStatusEvent.BuilderImpl> events) {
            this.events = InstanceStatusEventListCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<InstanceStatusEvent> events) {
            this.events = InstanceStatusEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InstanceStatusEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<InstanceStatusEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (InstanceStatusEvent)((InstanceStatusEvent.Builder)InstanceStatusEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final InstanceState.Builder getInstanceState() {
            return this.instanceState != null ? this.instanceState.toBuilder() : null;
        }

        public final void setInstanceState(InstanceState.BuilderImpl instanceState) {
            this.instanceState = instanceState != null ? instanceState.build() : null;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final InstanceStatusSummary.Builder getInstanceStatus() {
            return this.instanceStatus != null ? this.instanceStatus.toBuilder() : null;
        }

        public final void setInstanceStatus(InstanceStatusSummary.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        @Override
        public final Builder instanceStatus(InstanceStatusSummary instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final InstanceStatusSummary.Builder getSystemStatus() {
            return this.systemStatus != null ? this.systemStatus.toBuilder() : null;
        }

        public final void setSystemStatus(InstanceStatusSummary.BuilderImpl systemStatus) {
            this.systemStatus = systemStatus != null ? systemStatus.build() : null;
        }

        @Override
        public final Builder systemStatus(InstanceStatusSummary systemStatus) {
            this.systemStatus = systemStatus;
            return this;
        }

        public final EbsStatusSummary.Builder getAttachedEbsStatus() {
            return this.attachedEbsStatus != null ? this.attachedEbsStatus.toBuilder() : null;
        }

        public final void setAttachedEbsStatus(EbsStatusSummary.BuilderImpl attachedEbsStatus) {
            this.attachedEbsStatus = attachedEbsStatus != null ? attachedEbsStatus.build() : null;
        }

        @Override
        public final Builder attachedEbsStatus(EbsStatusSummary attachedEbsStatus) {
            this.attachedEbsStatus = attachedEbsStatus;
            return this;
        }

        public InstanceStatus build() {
            return new InstanceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStatus> {
        public Builder availabilityZone(String var1);

        public Builder outpostArn(String var1);

        public Builder operator(OperatorResponse var1);

        default public Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return this.operator((OperatorResponse)((OperatorResponse.Builder)OperatorResponse.builder().applyMutation(operator)).build());
        }

        public Builder events(Collection<InstanceStatusEvent> var1);

        public Builder events(InstanceStatusEvent ... var1);

        public Builder events(Consumer<InstanceStatusEvent.Builder> ... var1);

        public Builder instanceId(String var1);

        public Builder instanceState(InstanceState var1);

        default public Builder instanceState(Consumer<InstanceState.Builder> instanceState) {
            return this.instanceState((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(instanceState)).build());
        }

        public Builder instanceStatus(InstanceStatusSummary var1);

        default public Builder instanceStatus(Consumer<InstanceStatusSummary.Builder> instanceStatus) {
            return this.instanceStatus((InstanceStatusSummary)((InstanceStatusSummary.Builder)InstanceStatusSummary.builder().applyMutation(instanceStatus)).build());
        }

        public Builder systemStatus(InstanceStatusSummary var1);

        default public Builder systemStatus(Consumer<InstanceStatusSummary.Builder> systemStatus) {
            return this.systemStatus((InstanceStatusSummary)((InstanceStatusSummary.Builder)InstanceStatusSummary.builder().applyMutation(systemStatus)).build());
        }

        public Builder attachedEbsStatus(EbsStatusSummary var1);

        default public Builder attachedEbsStatus(Consumer<EbsStatusSummary.Builder> attachedEbsStatus) {
            return this.attachedEbsStatus((EbsStatusSummary)((EbsStatusSummary.Builder)EbsStatusSummary.builder().applyMutation(attachedEbsStatus)).build());
        }
    }
}

